/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class StringTag
extends Tag<String> {
    public StringTag() {
        this("");
    }

    public StringTag(@NotNull String value) {
        super(Objects.requireNonNull(value, "Null string not allowed!"));
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeUTF((String)this.getValue());
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        this.setValue(dis.readUTF());
    }

    @Override
    public byte getId() {
        return 8;
    }

    public String toString() {
        return "\"" + this.getTagName() + "\": \"" + (String)this.getValue() + "\"";
    }
}

