/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.UnknownTagException;
import com.mojang.nbt.tags.ByteArrayTag;
import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.DoubleArrayTag;
import com.mojang.nbt.tags.DoubleTag;
import com.mojang.nbt.tags.EndTag;
import com.mojang.nbt.tags.FloatTag;
import com.mojang.nbt.tags.IntTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.LongArrayTag;
import com.mojang.nbt.tags.LongTag;
import com.mojang.nbt.tags.ShortArrayTag;
import com.mojang.nbt.tags.ShortTag;
import com.mojang.nbt.tags.StringTag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Tag<T> {
    static final int TAG_END = 0;
    static final int TAG_BYTE = 1;
    static final int TAG_SHORT = 2;
    static final int TAG_INT = 3;
    static final int TAG_LONG = 4;
    static final int TAG_FLOAT = 5;
    static final int TAG_DOUBLE = 6;
    static final int TAG_BYTE_ARRAY = 7;
    static final int TAG_STRING = 8;
    static final int TAG_LIST = 9;
    static final int TAG_COMPOUND = 10;
    static final int TAG_SHORT_ARRAY = 11;
    static final int TAG_DOUBLE_ARRAY = 12;
    static final int TAG_LONG_ARRAY = 13;
    @Nullable
    private String name = null;
    private T value;

    public Tag() {
    }

    public Tag(T value) {
        this.value = value;
    }

    abstract void read(@NotNull DataInput var1) throws IOException;

    abstract void write(@NotNull DataOutput var1) throws IOException;

    public abstract byte getId();

    @NotNull
    public String getTagName() {
        return this.name == null ? "" : this.name;
    }

    @NotNull
    public Tag<T> setName(String key) {
        this.name = key;
        return this;
    }

    public T getValue() {
        return this.value;
    }

    @NotNull
    public Tag<T> setValue(T value) {
        this.value = value;
        return this;
    }

    public static Tag<?> readNamedTag(@NotNull DataInput dis) throws IOException {
        byte typeId = dis.readByte();
        if (typeId == 0) {
            return new EndTag();
        }
        try {
            Tag<?> tag = Tag.newTag(typeId);
            tag.name = dis.readUTF();
            tag.read(dis);
            return tag;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnknownTagException("Unknown tag type '" + typeId + "'!");
        }
    }

    public static void writeNamedTag(@NotNull Tag<?> tag, @NotNull DataOutput dos) throws IOException {
        dos.writeByte(tag.getId());
        if (tag.getId() != 0) {
            dos.writeUTF(tag.getTagName());
            tag.write(dos);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)obj;
        return Objects.equals(this.getValue(), tag.getValue());
    }

    @NotNull
    public static <T> Tag<T> createTagOfType(@NotNull Class<T> type) {
        if (type.isArray()) {
            Class<?> arrayType = type.getComponentType();
            if (arrayType == Byte.class || arrayType == Byte.TYPE) {
                return new ByteArrayTag();
            }
            if (arrayType == Short.class || arrayType == Short.TYPE) {
                return new ShortArrayTag();
            }
            if (arrayType == Long.class || arrayType == Long.TYPE) {
                return new LongArrayTag();
            }
            if (arrayType == Double.class || arrayType == Double.TYPE) {
                return new DoubleArrayTag();
            }
            throw new IllegalArgumentException("No NBT Tag type for array of '" + arrayType + "'!");
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new ByteTag();
        }
        if (type == Short.class || type == Short.TYPE) {
            return new ShortTag();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntTag();
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongTag();
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatTag();
        }
        if (type == Double.class || type == Double.TYPE) {
            return new DoubleTag();
        }
        if (type == String.class) {
            return new StringTag();
        }
        if (List.class.isAssignableFrom(type)) {
            return new ListTag();
        }
        if (Map.class.isAssignableFrom(type)) {
            return new CompoundTag();
        }
        throw new IllegalArgumentException("No NBT Tag type for type '" + type + "'!");
    }

    @NotNull
    public static Tag<?> newTag(byte type) {
        switch (type) {
            case 0: {
                return new EndTag();
            }
            case 1: {
                return new ByteTag();
            }
            case 2: {
                return new ShortTag();
            }
            case 3: {
                return new IntTag();
            }
            case 4: {
                return new LongTag();
            }
            case 5: {
                return new FloatTag();
            }
            case 6: {
                return new DoubleTag();
            }
            case 7: {
                return new ByteArrayTag();
            }
            case 8: {
                return new StringTag();
            }
            case 9: {
                return new ListTag();
            }
            case 10: {
                return new CompoundTag();
            }
            case 11: {
                return new ShortArrayTag();
            }
            case 12: {
                return new DoubleArrayTag();
            }
            case 13: {
                return new LongArrayTag();
            }
        }
        throw new IllegalArgumentException("No NBT Tag type for type '" + type + "'!");
    }

    @NotNull
    public static String getTagName(byte type) {
        switch (type) {
            case 0: {
                return "TAG_End";
            }
            case 1: {
                return "TAG_Byte";
            }
            case 2: {
                return "TAG_Short";
            }
            case 3: {
                return "TAG_Int";
            }
            case 4: {
                return "TAG_Long";
            }
            case 5: {
                return "TAG_Float";
            }
            case 6: {
                return "TAG_Double";
            }
            case 7: {
                return "TAG_Byte_Array";
            }
            case 8: {
                return "TAG_String";
            }
            case 9: {
                return "TAG_List";
            }
            case 10: {
                return "TAG_Compound";
            }
            case 11: {
                return "TAG_Short_Array";
            }
            case 12: {
                return "TAG_Double_Array";
            }
            case 13: {
                return "TAG_Long_Array";
            }
        }
        throw new IllegalArgumentException("No NBT Tag type for type '" + type + "'!");
    }
}

