/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.hud.component;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.hud.HudIngame;
import net.minecraft.client.gui.hud.component.HudComponentMovable;
import net.minecraft.client.gui.hud.component.layout.Layout;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.material.Material;
import org.lwjgl.opengl.GL11;

public class HudComponentOxygenBar
extends HudComponentMovable {
    private final IconCoordinate air = TextureRegistry.getTexture("minecraft:gui/hud/air");
    private final IconCoordinate air_pop = TextureRegistry.getTexture("minecraft:gui/hud/air_pop");

    public HudComponentOxygenBar(String key, Layout layout) {
        super(key, 81, 10, layout);
    }

    @Override
    public boolean isVisible(Minecraft mc) {
        return mc.gameSettings.immersiveMode.drawHotbar() && mc.playerController.canHurtPlayer() && !mc.thePlayer.getGamemode().isPlayerInvulnerable() && mc.thePlayer.isUnderLiquid(Material.water);
    }

    @Override
    public void render(Minecraft mc, HudIngame hud, int xSizeScreen, int ySizeScreen, float partialTick) {
        int x = this.getLayout().getComponentX(mc, this, xSizeScreen);
        int y = this.getLayout().getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        int numBubbles = (int)Math.ceil((double)(mc.thePlayer.airSupply - 2) * 10.0 / 300.0);
        int numPops = (int)Math.ceil((double)mc.thePlayer.airSupply * 10.0 / 300.0) - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                hud.drawGuiIcon(x + i * 8, y, 9, 9, this.air);
                continue;
            }
            hud.drawGuiIcon(x + i * 8, y, 9, 9, this.air_pop);
        }
    }

    @Override
    public void renderPreview(Minecraft mc, Gui gui, Layout layout, int xSizeScreen, int ySizeScreen) {
        int x = layout.getComponentX(mc, this, xSizeScreen);
        int y = layout.getComponentY(mc, this, ySizeScreen);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        int numBubbles = 5;
        int numPops = 6 - numBubbles;
        for (int i = 0; i < numBubbles + numPops; ++i) {
            if (i < numBubbles) {
                gui.drawGuiIcon(x + i * 8, y, 9, 9, this.air);
                continue;
            }
            gui.drawGuiIcon(x + i * 8, y, 9, 9, this.air_pop);
        }
    }
}

