/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.ListenerSliderElement;
import net.minecraft.core.entity.animal.MobSheep;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;

public class EntityEntrySheep
extends EntityEntry<MobSheep> {
    @Override
    public void onTick(MobSheep entity) {
    }

    @Override
    public List<ButtonElement> getEntryButtons(Minecraft mc, Screen parentScreen, MobSheep sheep) {
        ArrayList<ButtonElement> buttonList = new ArrayList<ButtonElement>();
        ListenerSliderElement slider = new ListenerSliderElement(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", "White"), 0.0f);
        slider.setOnValueChanged(() -> {
            sheep.setFleeceColor(DyeColor.colorFromBlockMeta((int)(slider.sliderValue * 15.0f)));
            String color = sheep.getFleeceColor().colorID;
            String c = String.valueOf(color.charAt(0));
            color = c.toUpperCase() + color.substring(1);
            slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", color);
        });
        buttonList.add(slider);
        return buttonList;
    }

    @Override
    public MobSheep getEntityInstance(Minecraft mc, World world) {
        MobSheep sheep = new MobSheep(world);
        sheep.setFleeceColor(DyeColor.WHITE);
        return sheep;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

