/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.glfw;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import net.minecraft.client.input.glfw.GlfwGamepad;
import org.lwjgl.glfw.GLFW;

public class GlfwJoystick {
    private final int id;
    private final int vid;
    private final int did;
    private FloatBuffer axes = null;
    private ByteBuffer buttons = null;
    private ByteBuffer hats = null;
    private GlfwGamepad gamepad = null;

    public GlfwJoystick(int id) {
        int did;
        int vid;
        this.id = id;
        String guid = this.getGuid();
        try {
            String lower = guid.substring(8, 10);
            String upper = guid.substring(10, 12);
            vid = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + id + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        try {
            String lower = guid.substring(16, 18);
            String upper = guid.substring(18, 20);
            did = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + id + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        this.vid = vid;
        this.did = did;
    }

    public int getId() {
        return this.id;
    }

    public String getGuid() {
        return GLFW.glfwGetJoystickGUID((int)this.id);
    }

    public int getVendorId() {
        return this.vid;
    }

    public int getDeviceId() {
        return this.did;
    }

    public void poll() {
        this.axes = GLFW.glfwGetJoystickAxes((int)this.id);
        this.buttons = GLFW.glfwGetJoystickButtons((int)this.id);
        this.hats = GLFW.glfwGetJoystickHats((int)this.id);
    }

    public boolean isPresent() {
        return GLFW.glfwJoystickPresent((int)this.id);
    }

    public String getName() {
        return GLFW.glfwGetJoystickName((int)this.id);
    }

    public float getAxisValue(int axis) {
        if (this.isPresent() && this.axes != null && axis >= 0 && axis < this.axes.capacity()) {
            return this.axes.get(axis);
        }
        return 0.0f;
    }

    public boolean isButtonPressed(int button) {
        if (this.isPresent() && this.buttons != null && button >= 0 && button < this.buttons.capacity()) {
            return this.buttons.get(button) == 1;
        }
        return false;
    }

    public int getHatValue(int hat) {
        if (this.isPresent() && this.hats != null && hat >= 0 && hat < this.hats.capacity()) {
            return this.hats.get(hat);
        }
        return 0;
    }

    public GlfwGamepad intoGamepad() {
        if (this.gamepad == null && this.isPresent() && GLFW.glfwJoystickIsGamepad((int)this.id)) {
            this.gamepad = new GlfwGamepad(this.id);
        }
        return this.gamepad;
    }
}

