/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player.controller;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.controller.PlayerController;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;

public class PlayerControllerSP
extends PlayerController {
    public PlayerControllerSP(Minecraft minecraft) {
        super(minecraft);
    }

    @Override
    public boolean destroyBlock(int x, int y, int z, Side side, Player player) {
        if (!player.getGamemode().canInteract() || this.mc.thePlayer.getHeldObject() != null) {
            return false;
        }
        int id = this.mc.currentWorld.getBlockId(x, y, z);
        int meta = this.mc.currentWorld.getBlockMetadata(x, y, z);
        TileEntity tileEntity = this.mc.currentWorld.getBlockEntity(x, y, z);
        boolean removed = super.destroyBlock(x, y, z, side, player);
        ItemStack item = this.mc.thePlayer.getCurrentEquippedItem();
        if (item != null) {
            item.onDestroyBlock(this.mc.currentWorld, id, x, y, z, side, this.mc.thePlayer);
        }
        if (removed && this.mc.thePlayer.getGamemode().dropBlockOnBreak()) {
            Blocks.blocksList[id].harvestBlock(this.mc.currentWorld, this.mc.thePlayer, x, y, z, meta, tileEntity);
        }
        if (item != null && item.stackSize <= 0) {
            this.mc.thePlayer.destroyCurrentEquippedItem();
        }
        return removed;
    }
}

