/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.TextureManager;
import net.minecraft.client.render.blockentity.TileEntityRenderer;
import net.minecraft.client.render.blockentity.TileEntityRendererFlag;
import net.minecraft.client.render.blockentity.TileEntityRendererFlowerJar;
import net.minecraft.client.render.blockentity.TileEntityRendererMeshGold;
import net.minecraft.client.render.blockentity.TileEntityRendererMobSpawner;
import net.minecraft.client.render.blockentity.TileEntityRendererMovingPiston;
import net.minecraft.client.render.blockentity.TileEntityRendererSign;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.block.entity.TileEntityFlowerJar;
import net.minecraft.core.block.entity.TileEntityMeshGold;
import net.minecraft.core.block.entity.TileEntityMobSpawner;
import net.minecraft.core.block.entity.TileEntitySign;
import net.minecraft.core.block.piston.TileEntityMovingPistonBlock;
import net.minecraft.core.world.World;
import org.lwjgl.opengl.GL11;

public class BlockEntityRenderDispatcher {
    private final Map<Class<?>, TileEntityRenderer<?>> renderers = new HashMap();
    public static BlockEntityRenderDispatcher instance = new BlockEntityRenderDispatcher();
    private Font font;
    public static double renderPosX;
    public static double renderPosY;
    public static double renderPosZ;
    public TextureManager textureManager;
    public World worldObj;
    public ICamera camera;
    public float viewLerpYaw;
    public float viewLerpPitch;
    public double viewLerpPosX;
    public double viewLerpPosY;
    public double viewLerpPosZ;

    private BlockEntityRenderDispatcher() {
        this.renderers.put(TileEntitySign.class, new TileEntityRendererSign());
        this.renderers.put(TileEntityFlag.class, new TileEntityRendererFlag());
        this.renderers.put(TileEntityMobSpawner.class, new TileEntityRendererMobSpawner());
        this.renderers.put(TileEntityMovingPistonBlock.class, new TileEntityRendererMovingPiston());
        this.renderers.put(TileEntityFlowerJar.class, new TileEntityRendererFlowerJar());
        this.renderers.put(TileEntityMeshGold.class, new TileEntityRendererMeshGold());
        for (TileEntityRenderer<?> tileEntityRenderer : this.renderers.values()) {
            tileEntityRenderer.setRenderDispatcher(this);
        }
    }

    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(Class<? extends TileEntity> e) {
        TileEntityRenderer<Object> r = this.renderers.get(e);
        if (r == null && e != TileEntity.class) {
            r = this.getRenderer((T)((Object)e.getSuperclass()));
            this.renderers.put(e, r);
        }
        return r;
    }

    public <T extends TileEntity> TileEntityRenderer<T> getRenderer(T tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        return this.getRenderer((T)((Object)tileEntity.getClass()));
    }

    public <T extends TileEntity> boolean hasRenderer(T tileEntity) {
        return this.getRenderer(tileEntity) != null;
    }

    public void cacheActiveRenderInfo(World world, TextureManager textureManager, Font font, ICamera camera, float partialTick) {
        if (this.worldObj != world) {
            this.updateRendererWorldCache(world);
        }
        this.textureManager = textureManager;
        this.camera = camera;
        this.font = font;
        this.viewLerpYaw = (float)camera.getYRot(partialTick);
        this.viewLerpPitch = (float)camera.getXRot(partialTick);
        this.viewLerpPosX = (float)camera.getX(partialTick);
        this.viewLerpPosY = (float)camera.getY(partialTick);
        this.viewLerpPosZ = (float)camera.getZ(partialTick);
    }

    public <T extends TileEntity> void renderTileEntity(Tessellator tessellator, T tileEntity, float partialTick) {
        if (tileEntity.getDistanceFrom(this.viewLerpPosX, this.viewLerpPosY, this.viewLerpPosZ) < 4096.0) {
            float brightness = 1.0f;
            if (LightmapHelper.isLightmapEnabled()) {
                LightmapHelper.setLightmapCoord(this.worldObj.getLightmapCoord(tileEntity.x, tileEntity.y, tileEntity.z, 0));
            } else if (!Global.accessor.isFullbrightEnabled()) {
                brightness = this.worldObj.getLightBrightness(tileEntity.x, tileEntity.y, tileEntity.z);
            }
            GL11.glColor3f((float)brightness, (float)brightness, (float)brightness);
            this.renderTileEntity(tessellator, tileEntity, (double)tileEntity.x - renderPosX, (double)tileEntity.y - renderPosY, (double)tileEntity.z - renderPosZ, partialTick);
        }
    }

    public <T extends TileEntity> void renderTileEntity(Tessellator tessellator, T tileEntity, double x, double y, double z, float partialTick) {
        TileEntityRenderer<T> renderer = this.getRenderer(tileEntity);
        if (renderer != null) {
            renderer.doRender(tessellator, tileEntity, x, y, z, partialTick);
        }
    }

    public void updateRendererWorldCache(World world) {
        this.worldObj = world;
        for (TileEntityRenderer<?> renderer : this.renderers.values()) {
            if (renderer == null) continue;
            renderer.onWorldChanged(world);
        }
    }

    public Font getFont() {
        return this.font;
    }
}

