/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelFire;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicBrazier;
import net.minecraft.core.block.BlockLogicFire;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelBrazier<T extends BlockLogicBrazier>
extends BlockModelStandard<T> {
    protected IconCoordinate sideTexture = TextureRegistry.getTexture("minecraft:block/brazier/side");
    protected IconCoordinate baseTexture = TextureRegistry.getTexture("minecraft:block/brazier/base");
    protected BlockModelStandard<?> fireModel = new BlockModelFire<BlockLogicFire>(Blocks.FIRE, true).withTextures("minecraft:block/fire");

    public BlockModelBrazier(Block<T> block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        tessellator.setColorOpaque_I(0xFFFFFF);
        BlockModelBrazier.renderBlocks.enableAO = true;
        BlockModelBrazier.renderBlocks.cache.setupCache(this.block, BlockModelBrazier.renderBlocks.blockAccess, x, y, z);
        AABB bounds = this.block.getBounds();
        this.renderSide(tessellator, bounds, x, y, z, Side.NORTH, 0);
        this.renderSide(tessellator, bounds, x, y, z, Side.SOUTH, 0);
        this.renderSide(tessellator, bounds, x, y, z, Side.EAST, 0);
        this.renderSide(tessellator, bounds, x, y, z, Side.WEST, 0);
        this.renderSide(tessellator, bounds, x, y, z, Side.BOTTOM, 0);
        double zFightOffset = 0.005;
        bounds.set(-0.005, -0.005, -0.005, 1.005, 1.005, 1.005);
        this.renderSide(tessellator, bounds, x, y, z + 1, Side.NORTH, 0);
        this.renderSide(tessellator, bounds, x, y, z - 1, Side.SOUTH, 0);
        this.renderSide(tessellator, bounds, x - 1, y, z, Side.EAST, 0);
        this.renderSide(tessellator, bounds, x + 1, y, z, Side.WEST, 0);
        this.renderSide(tessellator, bounds, x, y - 1, z, Side.TOP, 0);
        BlockModelBrazier.renderBlocks.enableAO = false;
        if (((BlockLogicBrazier)this.block.getLogic()).isBurning()) {
            this.fireModel.render(tessellator, x, y, z);
        }
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        AABB bounds = this.block.getBounds();
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)alpha);
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, -1.0f, 0.0f);
        this.renderBottomFace(tessellator, bounds, 0.0, 0.0, 0.0, this.baseTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 1.0f, 0.0f);
        this.renderTopFace(tessellator, bounds, 0.0, -1.0, 0.0, this.baseTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, -1.0f);
        this.renderNorthFace(tessellator, bounds, 0.0, 0.0, 1.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(0.0f, 0.0f, 1.0f);
        this.renderSouthFace(tessellator, bounds, 0.0, 0.0, -1.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(-1.0f, 0.0f, 0.0f);
        this.renderWestFace(tessellator, bounds, 1.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, 0.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        tessellator.startDrawingQuads();
        tessellator.setNormal(1.0f, 0.0f, 0.0f);
        this.renderEastFace(tessellator, bounds, -1.0, 0.0, 0.0, this.sideTexture);
        tessellator.draw();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side) {
        return true;
    }
}

