/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicChest;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelChest<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected IconCoordinate chestFrontSingle;
    protected IconCoordinate chestFrontLeft;
    protected IconCoordinate chestFrontRight;
    protected IconCoordinate chestBackLeft;
    protected IconCoordinate chestBackRight;
    protected IconCoordinate chestSide;
    protected IconCoordinate chestTop;

    public BlockModelChest(Block<T> block, String rootKey) {
        super(block);
        this.chestFrontSingle = TextureRegistry.getTexture(rootKey + "front");
        this.chestFrontLeft = TextureRegistry.getTexture(rootKey + "left_front");
        this.chestFrontRight = TextureRegistry.getTexture(rootKey + "right_front");
        this.chestBackLeft = TextureRegistry.getTexture(rootKey + "left_back");
        this.chestBackRight = TextureRegistry.getTexture(rootKey + "right_back");
        this.chestSide = TextureRegistry.getTexture(rootKey + "side");
        this.chestTop = TextureRegistry.getTexture(rootKey + "top");
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        if (side == Side.TOP || side == Side.BOTTOM) {
            return this.chestTop;
        }
        Side facing = BlockLogicChest.getDirectionFromMeta(meta).getSide();
        BlockLogicChest.Type type = BlockLogicChest.getTypeFromMeta(meta);
        if (type == BlockLogicChest.Type.SINGLE && side == facing) {
            return this.chestFrontSingle;
        }
        if (type == BlockLogicChest.Type.LEFT) {
            if (side == facing) {
                return this.chestFrontLeft;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackRight;
            }
        }
        if (type == BlockLogicChest.Type.RIGHT) {
            if (side == facing) {
                return this.chestFrontRight;
            }
            if (side == facing.getOpposite()) {
                return this.chestBackLeft;
            }
        }
        if (side.getAxis() != Axis.Y) {
            return this.chestSide;
        }
        return this.chestTop;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (side == Side.SOUTH) {
            return this.chestFrontSingle;
        }
        if (side.isHorizontal()) {
            return this.chestSide;
        }
        return this.chestTop;
    }
}

