/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;

public class BlockModelLeaves<T extends BlockLogic>
extends BlockModelStandard<T> {
    protected static boolean fancyGraphics;
    protected final IconCoordinate fancyLeavesTexture;
    protected final boolean canBeRetro;
    protected final IconCoordinate retroLeaves = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro");
    protected final IconCoordinate retroLeavesFancy = TextureRegistry.getTexture("minecraft:block/leaves/oak_retro_fancy");

    public BlockModelLeaves(Block<T> block, String leavesTex) {
        this(block, leavesTex, false);
    }

    public BlockModelLeaves(Block<T> block, String leavesTex, boolean canBeRetro) {
        super(block);
        this.setAllTextures(0, leavesTex);
        this.fancyLeavesTexture = TextureRegistry.getTexture(leavesTex + "_fancy");
        this.canBeRetro = canBeRetro;
    }

    public static void setGraphicsLevel(boolean graphicsLevel) {
        fancyGraphics = graphicsLevel;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        boolean invTint = BlockModelLeaves.renderBlocks.useInventoryTint;
        BlockModelLeaves.renderBlocks.useInventoryTint = this.canBeRetro && this.isRetro();
        super.renderBlockOnInventory(tessellator, metadata, brightness, alpha, lightmapCoordinate);
        BlockModelLeaves.renderBlocks.useInventoryTint = invTint;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        if (this.canBeRetro && this.isRetro()) {
            return this.renderStandardBlock(tessellator, this.block.getBlockBoundsFromState(BlockModelLeaves.renderBlocks.blockAccess, x, y, z), x, y, z, 1.0f, 1.0f, 1.0f);
        }
        return super.render(tessellator, x, y, z);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (this.canBeRetro && this.isRetro()) {
            return fancyGraphics ? this.retroLeavesFancy : this.retroLeaves;
        }
        return fancyGraphics ? this.fancyLeavesTexture : super.getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, int side) {
        int i1 = blockAccess.getBlockId(x, y, z);
        if (!fancyGraphics && i1 == this.block.id()) {
            return false;
        }
        return super.shouldSideBeRendered(blockAccess, bounds, x, y, z, side);
    }
}

