/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.FlagRenderer;
import net.minecraft.client.render.blockentity.TileEntityRenderer;
import net.minecraft.client.render.model.ModelFlag;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.world.WorldClient;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityFlag;
import net.minecraft.core.world.World;
import net.minecraft.core.world.wind.WindProvider;
import org.lwjgl.opengl.GL11;

public class TileEntityRendererFlag
extends TileEntityRenderer<TileEntityFlag> {
    public final Minecraft mc = Minecraft.getMinecraft();
    private final ModelFlag modelFlag = new ModelFlag(false);
    private final ModelFlag modelFlagMirrored = new ModelFlag(true);
    private static FlagRenderer flagRenderer = null;
    private long lastTick = 0L;

    @Override
    public void doRender(Tessellator tessellator, TileEntityFlag tileEntity, double x, double y, double z, float partialTick) {
        WorldClient theWorld = Minecraft.getMinecraft().currentWorld;
        int blockUnder = theWorld.getBlockId(tileEntity.x, tileEntity.y - 1, tileEntity.z);
        boolean shortPole = blockUnder == Blocks.FLAG.id();
        WindProvider theWind = this.mc.currentWorld.getWorldType().getWindManager();
        float windDirection = theWind.getWindDirection(this.mc.currentWorld, 0.0f, 500.0f, 0.0f) * 360.0f;
        float windIntensity = theWind.getWindIntensity(this.mc.currentWorld, 0.0f, 500.0f, 0.0f);
        this.doRender(tileEntity, x, y, z, partialTick, shortPole, windDirection, windIntensity);
    }

    public void doRender(TileEntityFlag tileEntityFlag, double x, double y, double z, float partialTick, boolean shortPole, float windDirection, float windIntensity) {
        WorldClient theWorld = Minecraft.getMinecraft().currentWorld;
        if (flagRenderer == null) {
            flagRenderer = new FlagRenderer(this.renderDispatcher.textureManager);
        }
        if (theWorld.getWorldTime() != this.lastTick) {
            this.lastTick = theWorld.getWorldTime();
            flagRenderer.tick();
        }
        float swayInterpolated = (float)tileEntityFlag.sway + partialTick;
        float sway = (float)((double)swayInterpolated / 1.5 % (Math.PI * 2));
        sway = (float)(Math.sin(sway) * (double)windIntensity * 2.0);
        GL11.glPushMatrix();
        float scale = 1.0f;
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.75f), (float)((float)z + 0.5f));
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        this.loadTexture("/assets/minecraft/textures/entity/flag.png");
        if (shortPole) {
            this.modelFlag.renderPoleShort();
        } else {
            this.modelFlag.renderBase();
            this.modelFlag.renderPole();
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(windDirection + sway), (float)0.0f, (float)1.0f, (float)0.0f);
        this.modelFlag.renderFlag();
        this.renderDispatcher.textureManager.bindTexture(flagRenderer.getTexture(tileEntityFlag));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)769, (int)768);
        if (tileEntityFlag.getFlipped()) {
            this.modelFlagMirrored.renderFlagOverlay();
        } else {
            this.modelFlag.renderFlagOverlay();
        }
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        float f4 = 0.01666667f;
        GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.07f);
        GL11.glScalef((float)0.01666667f, (float)-0.01666667f, (float)0.01666667f);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-0.01666667f);
        GL11.glPopMatrix();
    }

    @Override
    public void onWorldChanged(World world) {
        if (flagRenderer != null) {
            flagRenderer.flushCaches();
        }
    }
}

