/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.model.ModelCreeper;
import net.minecraft.core.entity.monster.MobCreeper;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;

public class MobRendererCreeper
extends MobRenderer<MobCreeper> {
    private ModelBase chargedModel = new ModelCreeper(2.0f);

    public MobRendererCreeper() {
        super(new ModelCreeper(), 0.5f);
    }

    @Override
    protected void setupScale(MobCreeper creeper, float partialTick) {
        float g = creeper.getSwelling(partialTick);
        float wobble = 1.0f + MathHelper.sin(g * 100.0f) * g * 0.01f;
        if (g < 0.0f) {
            g = 0.0f;
        }
        if (g > 1.0f) {
            g = 1.0f;
        }
        g *= g;
        g *= g;
        float s = (1.0f + g * 0.4f) * wobble;
        float hs = (1.0f + g * 0.1f) / wobble;
        GL11.glScalef((float)s, (float)hs, (float)s);
    }

    @Override
    protected int getOverlayColor(MobCreeper creeper, float brightness, float partialTick) {
        float step = creeper.getSwelling(partialTick);
        if ((int)(step * 10.0f) % 2 == 0) {
            return 0;
        }
        int _a = (int)(step * 0.2f * 255.0f);
        if (_a < 0) {
            _a = 0;
        }
        if (_a > 255) {
            _a = 255;
        }
        int r = 255;
        int g = 255;
        int b = 255;
        return _a << 24 | 0xFF0000 | 0xFF00 | 0xFF;
    }

    @Override
    protected boolean prepareArmor(MobCreeper entity, int layer, float partialTick) {
        if (entity.getPowered()) {
            if (layer == 1) {
                float f1 = (float)entity.tickCount + partialTick;
                this.bindTexture("/armor/power.png");
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                float f2 = f1 * 0.01f;
                float f3 = f1 * 0.01f;
                GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
                this.setArmorModel(this.chargedModel);
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)3042);
                float brightness = 0.5f;
                GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glBlendFunc((int)1, (int)1);
                return true;
            }
            if (layer == 2) {
                GL11.glMatrixMode((int)5890);
                GL11.glLoadIdentity();
                GL11.glMatrixMode((int)5888);
                GL11.glEnable((int)2896);
                GL11.glDisable((int)3042);
            }
        }
        return false;
    }
}

