/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.Global;
import net.minecraft.core.entity.animal.MobSheep;
import org.lwjgl.opengl.GL11;

public class MobRendererSheep
extends MobRenderer<MobSheep> {
    public MobRendererSheep(ModelBase body, ModelBase wool, ModelBase overlay, float f) {
        super(body, f);
        this.setArmorModel(wool);
        this.setOverlayModel(overlay, "/assets/minecraft/textures/entity/sheep_overlay.png");
    }

    protected boolean setWoolColorAndRender(MobSheep entitysheep, int i, float f) {
        if (i == 0 && !entitysheep.getSheared()) {
            this.bindTexture("/assets/minecraft/textures/entity/sheep_fur.png");
            float brightness = 1.0f;
            if (!LightmapHelper.isLightmapEnabled() && !Global.accessor.isFullbrightEnabled()) {
                brightness = entitysheep.getBrightness(f);
            }
            int j = entitysheep.getFleeceColor().blockMeta;
            GL11.glColor3f((float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][0]), (float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][1]), (float)(brightness * MobSheep.FLEECE_COLOR_TABLE[j][2]));
            return true;
        }
        return false;
    }

    @Override
    public void onUnload() {
        this.overlayModel.onUnload();
    }

    @Override
    protected boolean prepareArmor(MobSheep entity, int renderPass, float partialTick) {
        return this.setWoolColorAndRender(entity, renderPass, partialTick);
    }
}

