/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.shader;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.OpenGLHelper;
import net.minecraft.client.render.shader.ShaderProvider;
import org.lwjgl.opengl.GL20;
import org.slf4j.Logger;

public class Shader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private int program;
    private int vertexShader;
    private int fragmentShader;
    private boolean enabled = false;
    private final Map<String, Integer> uniformLocations = new HashMap<String, Integer>();

    public Shader compile(ShaderProvider folder, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        OpenGLHelper.checkError("pre compile shader " + name);
        this.delete();
        String fragmentSource = folder.getShaderSource(name + ".fsh");
        String vertexSource = folder.getShaderSource(name + ".vsh");
        if (fragmentSource == null) {
            return this;
        }
        if (vertexSource == null) {
            return this;
        }
        this.vertexShader = GL20.glCreateShader((int)35633);
        this.fragmentShader = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)this.vertexShader, (CharSequence)vertexSource);
        GL20.glShaderSource((int)this.fragmentShader, (CharSequence)fragmentSource);
        GL20.glCompileShader((int)this.vertexShader);
        GL20.glCompileShader((int)this.fragmentShader);
        int fragmentShaderCompileStatus = GL20.glGetShaderi((int)this.fragmentShader, (int)35713);
        int vertexShaderCompileStatus = GL20.glGetShaderi((int)this.vertexShader, (int)35713);
        if (fragmentShaderCompileStatus != 1 || vertexShaderCompileStatus != 1) {
            LOGGER.error("Shader {} compile error", (Object)name);
            if (vertexShaderCompileStatus != 1) {
                LOGGER.error("Vertex Shader Info Log:");
                LOGGER.error(GL20.glGetShaderInfoLog((int)this.vertexShader, (int)GL20.glGetShaderi((int)this.vertexShader, (int)35716)));
            }
            if (fragmentShaderCompileStatus != 1) {
                LOGGER.error("Vertex Shader Info Log:");
                LOGGER.error(GL20.glGetShaderInfoLog((int)this.fragmentShader, (int)GL20.glGetShaderi((int)this.fragmentShader, (int)35716)));
            }
            this.delete();
            return this;
        }
        this.program = GL20.glCreateProgram();
        GL20.glAttachShader((int)this.program, (int)this.fragmentShader);
        GL20.glAttachShader((int)this.program, (int)this.vertexShader);
        GL20.glLinkProgram((int)this.program);
        int programLinkStatus = GL20.glGetProgrami((int)this.program, (int)35714);
        if (programLinkStatus != 1) {
            LOGGER.error("Program Link Error: ");
            LOGGER.error(GL20.glGetProgramInfoLog((int)this.program, (int)GL20.glGetProgrami((int)this.program, (int)35716)));
            this.delete();
            return this;
        }
        GL20.glDeleteShader((int)this.vertexShader);
        GL20.glDeleteShader((int)this.fragmentShader);
        this.vertexShader = 0;
        this.fragmentShader = 0;
        this.enabled = true;
        OpenGLHelper.checkError("compile shader " + name);
        return this;
    }

    public int getUniform(String uniform) {
        Integer location = this.uniformLocations.get(uniform);
        if (location == null) {
            location = GL20.glGetUniformLocation((int)this.program, (CharSequence)uniform);
            this.uniformLocations.put(uniform, location);
        }
        return location;
    }

    public void delete() {
        this.enabled = false;
        this.uniformLocations.clear();
        OpenGLHelper.checkError("pre delete shader");
        if (this.program != 0) {
            GL20.glDeleteProgram((int)this.program);
            this.program = 0;
        }
        if (this.fragmentShader != 0) {
            GL20.glDeleteShader((int)this.fragmentShader);
            this.fragmentShader = 0;
        }
        if (this.vertexShader != 0) {
            GL20.glDeleteShader((int)this.vertexShader);
            this.vertexShader = 0;
        }
        OpenGLHelper.checkError("delete shader");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void bind() {
        GL20.glUseProgram((int)this.program);
    }

    public void unbind() {
        GL20.glUseProgram((int)0);
    }

    public static int getCompileStatus(int shader) {
        return GL20.glGetShaderi((int)shader, (int)35713);
    }

    public void uniformFloat(String name, float value) {
        GL20.glUniform1f((int)this.getUniform(name), (float)value);
    }

    public void uniformFloat(String name, boolean value) {
        this.uniformFloat(name, value ? 1.0f : 0.0f);
    }

    public void uniformInt(String name, int value) {
        GL20.glUniform1i((int)this.getUniform(name), (int)value);
    }

    public void uniformBool(String name, boolean value) {
        GL20.glUniform1i((int)this.getUniform(name), (int)(value ? 1 : 0));
    }
}

