/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.IPainted;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class BlockLogicLamp
extends BlockLogic
implements IPainted {
    public boolean isActive;

    public BlockLogicLamp(Block<?> block, boolean isActivated) {
        super(block, Material.stone);
        this.isActive = isActivated;
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        if (this.isActive && !world.hasDirectSignal(x, y, z) && !world.hasNeighborSignal(x, y, z)) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id(), world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onBlockPlacedOnSide(World world, int x, int y, int z, @NotNull Side side, double xPlaced, double yPlaced) {
        boolean hasSignal;
        if (world.isClientSide) {
            return;
        }
        boolean bl = hasSignal = world.hasDirectSignal(x, y, z) || world.hasNeighborSignal(x, y, z);
        if (hasSignal && !this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_ACTIVE.id(), world.getBlockMetadata(x, y, z));
        } else if (!hasSignal && this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id(), world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean hasSignal;
        boolean bl = hasSignal = world.hasDirectSignal(x, y, z) || world.hasNeighborSignal(x, y, z);
        if (hasSignal && !this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_ACTIVE.id(), world.getBlockMetadata(x, y, z));
        } else if (!hasSignal && this.isActive) {
            world.setBlockAndMetadataWithNotify(x, y, z, Blocks.LAMP_IDLE.id(), world.getBlockMetadata(x, y, z));
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Blocks.LAMP_IDLE, 1, meta)};
    }

    @Override
    public DyeColor fromMetadata(int meta) {
        return DyeColor.colorFromBlockMeta(meta & 0xF);
    }

    @Override
    public int toMetadata(DyeColor color) {
        return color.blockMeta;
    }

    @Override
    public int stripColorFromMetadata(int meta) {
        return 0;
    }

    @Override
    public void removeDye(World world, int x, int y, int z) {
        world.setBlockMetadataWithNotify(x, y, z, 0);
    }
}

