/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.BlockLogicOreRedstone;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityActivator;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.sound.SoundCategory;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class BlockLogicNote
extends BlockLogic {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MASK_NOTE = 63;
    public static final int MASK_POWERED = 128;
    public static final byte MAX_NOTE = 24;

    public BlockLogicNote(Block<?> block) {
        super(block, Material.wood);
        block.withEntity(null);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean flag = world.hasNeighborSignal(x, y, z);
        int data = world.getBlockMetadata(x, y, z);
        if (BlockLogicNote.isPowered(data) && !flag) {
            world.setBlockMetadata(x, y, z, BlockLogicNote.setPowered(data, false));
        } else if (!BlockLogicNote.isPowered(data) && flag) {
            this.triggerNote(world, x, y, z);
            world.setBlockMetadata(x, y, z, BlockLogicNote.setPowered(data, true));
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            this.changePitch(world, x, y, z);
            this.triggerNote(world, x, y, z);
        }
        return true;
    }

    @Override
    public void onActivatorInteract(World world, int x, int y, int z, TileEntityActivator activator, Direction direction) {
        this.changePitch(world, x, y, z);
        this.triggerNote(world, x, y, z);
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        if (!world.isClientSide) {
            this.triggerNote(world, x, y, z);
        }
    }

    public void changePitch(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        world.setBlockMetadata(x, y, z, BlockLogicNote.setNote(meta, (BlockLogicNote.getNote(meta) + 1) % 25));
    }

    public void triggerNote(World world, int x, int y, int z) {
        if (world.isBlockOpaqueCube(x, y + 1, z)) {
            return;
        }
        world.triggerEvent(x, y, z, Instrument.getInstrumentFromBlock(world.getBlock((int)x, (int)(y - 1), (int)z)).index, BlockLogicNote.getNote(world.getBlockMetadata(x, y, z)));
    }

    public static int setNote(int data, int note) {
        return data & 0xFFFFFFC0 | note & 0x3F;
    }

    public static int getNote(int data) {
        return data & 0x3F;
    }

    public static boolean isPowered(int data) {
        return (data & 0x80) != 0;
    }

    public static int setPowered(int data, boolean flag) {
        if (flag) {
            return data | 0x80;
        }
        return data & 0xFFFFFF7F;
    }

    @Override
    public void triggerEvent(World world, int x, int y, int z, int index, int data) {
        float f = (float)Math.pow(2.0, (double)(data - 12) / 12.0);
        String s = Instrument.getInstrumentFromIndex((int)index).soundKey;
        world.playSoundEffect(null, SoundCategory.WORLD_SOUNDS, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "note." + s, 3.0f, f);
        world.spawnParticle("note", (double)x + 0.5, (double)y + 1.2, (double)z + 0.5, 0.0, 0.0, 0.0, data);
    }

    public static class Instrument {
        public static final Map<Integer, Instrument> instrumentMap = new HashMap<Integer, Instrument>();
        public final int index;
        public final String soundKey;
        public static Instrument DEFAULT;
        public static final Instrument BD;
        public static final Instrument SNARE;
        public static final Instrument HAT;
        public static final Instrument BASS_ATTACK;
        public static final Instrument HARP;
        public static final Instrument CHANT;
        public static final Instrument DRUM_STEEL;
        public static final Instrument CHIP_TRIANGLE;
        public static final Instrument GUITAR_ELECTRIC;
        public static final Instrument CELESTA;
        public static final Instrument WOOD_BLOCK;

        public Instrument(int index, String soundKey) {
            this.index = index;
            this.soundKey = soundKey;
            assert (!instrumentMap.containsKey(index)) : "Only 1 instrument can be assigned per index!";
            instrumentMap.put(index, this);
        }

        @NotNull
        public static Instrument getInstrumentFromIndex(int index) {
            if (instrumentMap.containsKey(index)) {
                return instrumentMap.get(index);
            }
            LOGGER.warn("No instrument assign to index '{}'!", (Object)index);
            return instrumentMap.getOrDefault(index, DEFAULT);
        }

        @NotNull
        public static Instrument getInstrumentFromBlock(@Nullable Block<?> block) {
            if (block == null) {
                return DEFAULT;
            }
            if (block == Blocks.BLOCK_OLIVINE) {
                return CHIP_TRIANGLE;
            }
            if (block == Blocks.BLOCK_REDSTONE || block == Blocks.PUMPKIN_REDSTONE || block.getLogic() instanceof BlockLogicOreRedstone) {
                return GUITAR_ELECTRIC;
            }
            if (block == Blocks.CHEST_PLANKS_OAK || block == Blocks.CHEST_PLANKS_OAK_PAINTED) {
                return WOOD_BLOCK;
            }
            Material material = block.getMaterial();
            if (material == Material.permafrost || material == Material.ice) {
                return CELESTA;
            }
            if (material.isStone()) {
                return BD;
            }
            if (material == Material.sand) {
                return SNARE;
            }
            if (material == Material.glass) {
                return HAT;
            }
            if (material == Material.wood) {
                return BASS_ATTACK;
            }
            if (material == Material.soulsand) {
                return CHANT;
            }
            if (material == Material.steel) {
                return DRUM_STEEL;
            }
            return DEFAULT;
        }

        static {
            HARP = new Instrument(0, "harp");
            BD = new Instrument(1, "bd");
            SNARE = new Instrument(2, "snare");
            HAT = new Instrument(3, "hat");
            BASS_ATTACK = new Instrument(4, "bassattack");
            CHANT = new Instrument(5, "chant");
            DRUM_STEEL = new Instrument(6, "drum_steel");
            CHIP_TRIANGLE = new Instrument(7, "chip_triangle");
            GUITAR_ELECTRIC = new Instrument(8, "guitar_electric");
            CELESTA = new Instrument(9, "celesta");
            WOOD_BLOCK = new Instrument(10, "wood_block");
            DEFAULT = HARP;
        }
    }
}

