/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockLogicOreRedstone
extends BlockLogic {
    public static Map<Integer, Integer> variantMap = new HashMap<Integer, Integer>();
    private final boolean illuminated;
    private final Block<?> normalBlock;
    private final Block<?> illuminatedBlock;

    public BlockLogicOreRedstone(Block<?> block, Block<?> parentBlock, Material material, boolean illuminated, Block<?> normalBlock, Block<?> illuminatedBlock) {
        super(block, material);
        if (illuminated) {
            block.setTicking(true);
        }
        this.illuminated = illuminated;
        this.normalBlock = normalBlock;
        this.illuminatedBlock = illuminatedBlock;
        if (parentBlock != null) {
            variantMap.put(parentBlock.id(), block.id());
        }
    }

    @Override
    public int tickDelay() {
        return 30;
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        this.lightRedstone(world, x, y, z);
        super.onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.lightRedstone(world, x, y, z);
        super.onEntityWalking(world, x, y, z, entity);
    }

    private void lightRedstone(World world, int x, int y, int z) {
        this.spawnParticles(world, x, y, z);
        if (!this.illuminated) {
            world.setBlockWithNotify(x, y, z, this.illuminatedBlock.id());
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            world.setBlockWithNotify(x, y, z, this.normalBlock.id());
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case SILK_TOUCH: 
            case PICK_BLOCK: {
                return new ItemStack[]{new ItemStack(this.normalBlock)};
            }
            case EXPLOSION: 
            case PROPER_TOOL: 
            case PISTON_CRUSH: {
                return new ItemStack[]{new ItemStack(Items.DUST_REDSTONE, 4 + world.rand.nextInt(2))};
            }
        }
        return null;
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        if (this.illuminated) {
            this.spawnParticles(world, x, y, z);
        }
    }

    private void spawnParticles(World world, int x, int y, int z) {
        Random random = world.rand;
        int redstoneBrightness = 10;
        double d = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double px = (double)x + (double)random.nextFloat();
            double py = (double)y + (double)random.nextFloat();
            double pz = (double)z + (double)random.nextFloat();
            if (i == 0 && !world.isBlockOpaqueCube(x, y + 1, z)) {
                py = (double)(y + 1) + d;
            }
            if (i == 1 && !world.isBlockOpaqueCube(x, y - 1, z)) {
                py = (double)y - d;
            }
            if (i == 2 && !world.isBlockOpaqueCube(x, y, z + 1)) {
                pz = (double)(z + 1) + d;
            }
            if (i == 3 && !world.isBlockOpaqueCube(x, y, z - 1)) {
                pz = (double)z - d;
            }
            if (i == 4 && !world.isBlockOpaqueCube(x + 1, y, z)) {
                px = (double)(x + 1) + d;
            }
            if (i == 5 && !world.isBlockOpaqueCube(x - 1, y, z)) {
                px = (double)x - d;
            }
            if (!(px < (double)x || px > (double)(x + 1) || py < 0.0 || py > (double)(y + 1) || pz < (double)z) && !(pz > (double)(z + 1))) continue;
            world.spawnParticle("reddust", px, py, pz, 0.0, 0.0, 0.0, 10);
        }
    }
}

