/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicLayerBase;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.ItemBlock;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.Nullable;

public class ItemBlockLayer<T extends BlockLogicLayerBase>
extends ItemBlock<T> {
    public ItemBlockLayer(Block<T> block) {
        super(block);
    }

    @Override
    public boolean onUseItemOnBlock(ItemStack itemstack, @Nullable Player player, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        Block<?> targetBlock = world.getBlock(blockX, blockY, blockZ);
        int meta = world.getBlockMetadata(blockX, blockY, blockZ);
        if (targetBlock != this.block && targetBlock != null && targetBlock.hasTag(BlockTags.PLACE_OVERWRITES)) {
            targetBlock = null;
            meta = 0;
        }
        if (itemstack.stackSize <= 0) {
            return false;
        }
        if (blockY == world.getHeightBlocks() - 1 && this.block.getMaterial().isSolid()) {
            return false;
        }
        if (targetBlock == this.block && side == Side.TOP) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABB bbBox = AABB.getTemporaryBB(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.block.id(), newMeta);
            } else if (blockLayer.fullBlock != null) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, blockLayer.fullBlock.id(), 0);
            } else {
                world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.block.id(), 0);
            }
            world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(player);
            return true;
        }
        if (targetBlock != null) {
            targetBlock = world.getBlock(blockX += side.getOffsetX(), blockY += side.getOffsetY(), blockZ += side.getOffsetZ());
            meta = world.getBlockMetadata(blockX, blockY, blockZ);
        }
        if (targetBlock == this.block) {
            BlockLogicLayerBase blockLayer = (BlockLogicLayerBase)this.block.getLogic();
            int newMeta = meta + 1;
            AABB bbBox = AABB.getTemporaryBB(blockX, blockY, blockZ, (float)blockX + 1.0f, (float)blockY + (float)(2 * (newMeta + 1)) / 16.0f, (float)blockZ + 1.0f);
            if (!world.checkIfAABBIsClear(bbBox)) {
                return false;
            }
            if (newMeta < 7) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.block.id(), newMeta);
            } else if (blockLayer.fullBlock != null) {
                world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, blockLayer.fullBlock.id(), 0);
            } else {
                world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.block.id(), 0);
            }
            world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
            itemstack.consumeItem(player);
            return true;
        }
        if (world.canBlockBePlacedAt(this.block.id(), blockX, blockY, blockZ, false, side)) {
            int placeMeta = this.getPlacedBlockMetadata(player, itemstack, world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
            if (world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.block.id(), placeMeta)) {
                if (player == null) {
                    this.block.onBlockPlacedOnSide(world, blockX, blockY, blockZ, side, xPlaced, yPlaced);
                } else {
                    this.block.onBlockPlacedByMob(world, blockX, blockY, blockZ, Side.NONE, player, xPlaced, yPlaced);
                }
                world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.block, EnumBlockSoundEffectType.PLACE);
                itemstack.consumeItem(player);
                return true;
            }
        }
        return false;
    }
}

