/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.entity.entries;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityFishingBobber;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.net.entity.EntityTracker;
import net.minecraft.core.net.entity.EntityTrackerEntry;
import net.minecraft.core.net.entity.ITrackedEntry;
import net.minecraft.core.net.entity.IVehicleEntry;
import net.minecraft.core.net.packet.PacketAddEntity;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;

public class NetEntryBobber
implements IVehicleEntry<EntityFishingBobber>,
ITrackedEntry<EntityFishingBobber> {
    @Override
    @NotNull
    public Class<EntityFishingBobber> getAppliedClass() {
        return EntityFishingBobber.class;
    }

    @Override
    public int getTrackingDistance() {
        return 64;
    }

    @Override
    public int getPacketDelay() {
        return 5;
    }

    @Override
    public boolean sendMotionUpdates() {
        return true;
    }

    @Override
    public void onEntityTracked(EntityTracker tracker, EntityTrackerEntry trackerEntry, EntityFishingBobber trackedObject) {
    }

    @Override
    public Entity getEntity(World world, double x, double y, double z, int metadata, boolean hasVelocity, double xd, double yd, double zd, Entity owner) {
        EntityFishingBobber bobber = new EntityFishingBobber(world, x, y, z);
        if (owner != null) {
            bobber.owner = (Player)owner;
            ((Player)owner).bobberEntity = bobber;
        }
        return bobber;
    }

    @Override
    public PacketAddEntity getSpawnPacket(EntityTrackerEntry tracker, EntityFishingBobber bobber) {
        return new PacketAddEntity(bobber, 0, bobber.owner == null ? -1 : bobber.owner.id);
    }
}

