/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.PacketHandler;
import net.minecraft.core.net.packet.Packet;

public class PacketCustomPayload
extends Packet {
    public static final int MAX_CHANNEL_SIZE = 128;
    public String channel;
    public byte[] data;

    public PacketCustomPayload() {
    }

    public PacketCustomPayload(String channel, byte[] data) {
        this.channel = channel;
        if (data != null) {
            if (data.length > 32768) {
                throw new IllegalArgumentException("Payload may not be larger than 32k");
            }
            this.data = data;
        }
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        this.channel = PacketCustomPayload.readString(in, 128);
        int length = in.readInt();
        if (length > 0 && length < 32768) {
            this.data = new byte[length];
            in.read(this.data);
        }
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        PacketCustomPayload.writeString(this.channel, out);
        if (this.data != null) {
            out.writeInt(this.data.length);
            out.write(this.data);
        } else {
            out.writeInt(0);
        }
    }

    @Override
    public void handlePacket(PacketHandler packetHandler) {
        packetHandler.handleCustomPayload(this);
    }

    @Override
    public int getEstimatedSize() {
        return this.channel.length() + 4 + this.data.length;
    }
}

