/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.sound;

import com.b100.utils.StringUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class SoundTypes {
    private static final Map<Integer, String> idToSoundNameMap = new HashMap<Integer, String>();
    private static final Map<String, Integer> soundNameToIdMap = new HashMap<String, Integer>();
    private static int idCount = 0;

    public static void registerSounds() {
        SoundTypes.loadSoundsJson("/assets/minecraft/sounds/sounds.json");
    }

    public static void loadSoundsJson(String path) {
        JsonObject o;
        try {
            o = SoundTypes.loadStreamAsElement(SoundTypes.class.getResourceAsStream(path)).getAsJsonObject();
        }
        catch (Exception e) {
            System.err.println("Failed to load '" + path + "' as a json!");
            e.printStackTrace();
            return;
        }
        for (String s : o.asMap().keySet()) {
            SoundTypes.register(s);
        }
    }

    private static JsonElement loadStreamAsElement(InputStream stream) throws JsonParseException {
        return JsonParser.parseString(StringUtils.readInputString(stream));
    }

    public static boolean register(String soundPath) {
        if (soundPath.length() > 128) {
            throw new RuntimeException("Sound Path is too long: '" + soundPath + "'!");
        }
        if (soundNameToIdMap.containsKey(soundPath)) {
            return false;
        }
        int id = idCount++;
        idCount %= 65536;
        soundNameToIdMap.put(soundPath, id);
        idToSoundNameMap.put(id, soundPath);
        return true;
    }

    public static int getSoundId(String soundPath) {
        Integer id = soundNameToIdMap.get(soundPath);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static String getSoundById(int id) {
        return idToSoundNameMap.get(id);
    }

    public static void setSoundIds(Map<Integer, String> soundIds) {
        idToSoundNameMap.clear();
        soundNameToIdMap.clear();
        for (Map.Entry<Integer, String> entry : soundIds.entrySet()) {
            int id = entry.getKey();
            String name = entry.getValue();
            idToSoundNameMap.put(id, name);
            soundNameToIdMap.put(name, id);
        }
    }

    public static Map<Integer, String> getSoundIds() {
        return idToSoundNameMap;
    }
}

