/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.chunk;

import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.EmptyChunk;

public class DisplayChunk
extends EmptyChunk {
    public static int displayBlockId = 0;
    public static int displayBlockMeta = 0;
    public static int displayBlockPosX = 0;
    public static int displayBlockPosY = 0;
    public static int displayBlockPosZ = 0;
    public static TileEntity displayTileEntity = null;

    public DisplayChunk(World world, int x, int z) {
        super(world, x, z);
    }

    @Override
    public int getBlockID(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayBlockId;
        }
        return 0;
    }

    @Override
    public int getBlockMetadata(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayBlockMeta;
        }
        return 0;
    }

    @Override
    public int getBrightness(LightLayer layer, int x, int y, int z) {
        return 15;
    }

    @Override
    public boolean setBlockEntity(int x, int y, int z, TileEntity tileEntity) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            displayTileEntity = tileEntity;
            DisplayChunk.displayTileEntity.worldObj = this.world;
            DisplayChunk.displayTileEntity.x = x;
            DisplayChunk.displayTileEntity.y = y;
            DisplayChunk.displayTileEntity.z = z;
        }
        return true;
    }

    @Override
    public void removeBlockEntity(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            displayTileEntity = null;
        }
    }

    @Override
    public TileEntity getBlockEntity(int x, int y, int z) {
        if (x == displayBlockPosX && y == displayBlockPosY && z == displayBlockPosZ) {
            return displayTileEntity;
        }
        return null;
    }

    public static void setDisplayTileEntity(World world, TileEntity entity) {
        displayTileEntity = entity;
        if (displayTileEntity != null) {
            DisplayChunk.displayTileEntity.worldObj = world;
            DisplayChunk.displayTileEntity.x = displayBlockPosX;
            DisplayChunk.displayTileEntity.y = displayBlockPosY;
            DisplayChunk.displayTileEntity.z = displayBlockPosZ;
        }
    }
}

