/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.mojang.logging.LogUtils;
import java.net.ConnectException;
import java.net.UnknownHostException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenConnectFailed;
import net.minecraft.client.gui.ScreenMainMenu;
import net.minecraft.client.gui.ScreenSelectServer;
import net.minecraft.client.net.handler.PacketHandlerClient;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.packet.PacketPreLogin;
import org.slf4j.Logger;

public class ScreenConnecting
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private PacketHandlerClient clientHandler;
    private boolean cancelled;

    public ScreenConnecting(Minecraft minecraft, String hostName, int port) {
        this.mc = minecraft;
        this.cancelled = false;
        LOGGER.info("Connecting to {}, {}", (Object)hostName, (Object)port);
        minecraft.changeWorld(null);
        new Thread(() -> {
            try {
                this.clientHandler = new PacketHandlerClient(this.mc, hostName, port);
                if (this.cancelled) {
                    return;
                }
                this.clientHandler.addToSendQueue(new PacketPreLogin(this.mc.session.username));
            }
            catch (UnknownHostException unknownhostexception) {
                if (this.cancelled) {
                    return;
                }
                this.mc.displayScreen(new ScreenConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{"Unknown host '" + hostName + "'"}));
            }
            catch (ConnectException connectexception) {
                if (this.cancelled) {
                    return;
                }
                this.mc.displayScreen(new ScreenConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{connectexception.getMessage()}));
            }
            catch (Exception exception) {
                if (this.cancelled) {
                    return;
                }
                LOGGER.error("Unexpected Exception when trying to join server!", exception);
                this.mc.displayScreen(new ScreenConnectFailed("connect.failed", "disconnect.genericReason", new Object[]{exception.toString()}));
            }
        }).start();
    }

    @Override
    public void tick() {
        if (this.clientHandler != null) {
            this.clientHandler.tick();
        }
    }

    @Override
    public void keyPressed(char eventCharacter, int eventKey, int mx, int my) {
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.buttons.clear();
        this.buttons.add(new ButtonElement(0, this.width / 2 - 100, this.height / 4 + 120 + 12, stringtranslate.translateKey("gui.connecting.button.cancel")));
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        if (button.id == 0) {
            this.cancelled = true;
            if (this.clientHandler != null) {
                this.clientHandler.disconnect();
            }
            this.mc.displayScreen(new ScreenSelectServer(new ScreenMainMenu()));
        }
    }

    @Override
    public void render(int xm, int ym, float partialTick) {
        this.renderBackground();
        I18n stringtranslate = I18n.getInstance();
        if (this.clientHandler == null) {
            this.drawStringCentered(this.font, stringtranslate.translateKey("gui.connecting.label.connecting"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.font, "", this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        } else {
            this.drawStringCentered(this.font, stringtranslate.translateKey("gui.connecting.label.logging_in"), this.width / 2, this.height / 2 - 50, 0xFFFFFF);
            this.drawStringCentered(this.font, this.clientHandler.message, this.width / 2, this.height / 2 - 10, 0xFFFFFF);
        }
        super.render(xm, ym, partialTick);
    }
}

