/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.sdl.SDLGamepad;
import org.libsdl.SDL;
import org.slf4j.Logger;

public abstract class InputHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Minecraft minecraft;
    public static List<ControllerInput> controllers;
    private static boolean sdl2Initialized;

    public static void init(Minecraft minecraft) throws Exception {
        InputHandler.minecraft = minecraft;
        try {
            InputHandler.initSDL2(minecraft);
        }
        catch (Throwable e) {
            LOGGER.error("Could not initialize SDL2.");
            e.printStackTrace();
        }
    }

    public static void poll() {
        if (sdl2Initialized) {
            SDL.SDL_GameControllerUpdate();
            try {
                for (int i = 0; i < controllers.size(); ++i) {
                    ControllerInput input = controllers.get(i);
                    if (input.getController().isPresent()) continue;
                    InputHandler.disconnected(controllers.remove(i));
                    --i;
                }
                int joysticks = SDL.SDL_NumJoysticks();
                for (int i = 0; i < joysticks; ++i) {
                    if (!SDL.SDL_IsGameController(i)) continue;
                    int instanceId = SDL.SDL_JoystickGetDeviceInstanceID(i);
                    boolean containsId = false;
                    for (ControllerInput input : controllers) {
                        if (input.getController().getInstanceId() != instanceId) continue;
                        containsId = true;
                        break;
                    }
                    if (containsId) continue;
                    ControllerInput ci = new ControllerInput(minecraft, new SDLGamepad(i));
                    controllers.add(ci);
                    InputHandler.connected(ci);
                }
                for (ControllerInput ci : controllers) {
                    if (!ci.hasAnyInput()) continue;
                    InputHandler.minecraft.controllerInput = ci;
                    minecraft.setInputType(InputType.CONTROLLER);
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    private static void connected(ControllerInput controller) {
        LOGGER.info("Controller connected: {}", (Object)controller.getGUID());
        InputHandler.minecraft.controllerInput = controller;
    }

    private static void disconnected(ControllerInput controller) {
        LOGGER.info("Controller disconnected: {}", (Object)controller.getGUID());
        if (InputHandler.minecraft.controllerInput == controller) {
            minecraft.setInputType(InputType.KEYBOARD);
            InputHandler.minecraft.controllerInput = null;
        }
    }

    public static void initSDL2(Minecraft minecraft) throws Throwable {
        SDL.SDL_SetHint("SDL_JOYSTICK_RAWINPUT", "0");
        int result = SDL.SDL_Init(SDL.SDL_INIT_JOYSTICK | SDL.SDL_INIT_GAMECONTROLLER);
        if (result < 0) {
            throw new IOException("Could not initialize SDL2!");
        }
        sdl2Initialized = true;
        InputHandler.poll();
    }

    public static ControllerInput getController(String guid) {
        try {
            for (ControllerInput controllerInput : controllers) {
                if (!controllerInput.getGUID().equalsIgnoreCase(guid)) continue;
                return controllerInput;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        controllers = new ArrayList<ControllerInput>();
        sdl2Initialized = false;
    }
}

