/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.sdl;

import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.libsdl.SDL;

public class SDLGamepad {
    private static final float AXIS_MIN = SDL.SDL_JOYSTICK_AXIS_MIN();
    private static final float AXIS_MAX = SDL.SDL_JOYSTICK_AXIS_MAX();
    private final int instanceId;
    private final long joystickPtr;
    private final long gameControllerPtr;
    private final int vid;
    private final int did;

    public SDLGamepad(int index) throws Exception {
        int did;
        int vid;
        this.joystickPtr = SDL.SDL_JoystickOpen(index);
        if (this.joystickPtr == 0L) {
            throw new IOException(SDL.SDL_GetError());
        }
        this.gameControllerPtr = SDL.SDL_GameControllerOpen(index);
        if (this.gameControllerPtr == 0L) {
            throw new IOException(SDL.SDL_GetError());
        }
        this.instanceId = SDL.SDL_JoystickInstanceID(this.joystickPtr);
        String guid = this.getGuid();
        try {
            String lower = guid.substring(8, 10);
            String upper = guid.substring(10, 12);
            vid = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + index + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        try {
            String lower = guid.substring(16, 18);
            String upper = guid.substring(18, 20);
            did = Integer.parseInt(upper + lower, 16);
        }
        catch (Exception e) {
            System.out.println("Controller " + index + " has weird GUID!");
            this.vid = 0;
            this.did = 0;
            return;
        }
        this.vid = vid;
        this.did = did;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        SDL.SDL_GameControllerClose(this.gameControllerPtr);
        SDL.SDL_JoystickClose(this.joystickPtr);
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    @NotNull
    public String getGuid() {
        return SDL.SDL_JoystickGUIDString(this.joystickPtr);
    }

    public int getVendorId() {
        return this.vid;
    }

    public int getDeviceId() {
        return this.did;
    }

    public boolean isPresent() {
        return SDL.SDL_GameControllerGetAttached(this.gameControllerPtr);
    }

    @NotNull
    public String getName() {
        return SDL.SDL_GameControllerName(this.gameControllerPtr);
    }

    public boolean hasAnyInput() {
        int i;
        for (i = 0; i < 15; ++i) {
            if (!this.isButtonPressed(i)) continue;
            return true;
        }
        for (i = 0; i < 6; ++i) {
            if (!(Math.abs(this.getAxisValue(i)) > 0.5f)) continue;
            return true;
        }
        return false;
    }

    public float getAxisValue(int axis) {
        if (this.isPresent()) {
            int result = SDL.SDL_GameControllerGetAxis(this.gameControllerPtr, axis);
            if (result < 0) {
                return (float)result / -AXIS_MIN;
            }
            return (float)result / AXIS_MAX;
        }
        return 0.0f;
    }

    public boolean isButtonPressed(int button) {
        if (this.isPresent()) {
            return SDL.SDL_GameControllerGetButton(this.gameControllerPtr, button) == 1;
        }
        return false;
    }
}

