/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texturepack;

import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.texture.TextureBuffered;
import net.minecraft.client.render.texturepack.Manifest;
import net.minecraft.client.render.texturepack.TexturePack;
import org.slf4j.Logger;

public class TexturePackDefault
extends TexturePack {
    private static final Logger LOGGER = LogUtils.getLogger();
    private TextureBuffered texturePackThumbnailTexture = null;
    private BufferedImage texturePackThumbnail;

    public TexturePackDefault() {
        this.fileName = "Default";
        this.manifest = new Manifest(null, TexturePackDefault.class.getResourceAsStream("/manifest.json"));
        try {
            this.texturePackThumbnail = ImageIO.read(TexturePackDefault.class.getResource("/pack.png"));
        }
        catch (IOException e) {
            LOGGER.error("Failed to read thumbnail for '{}'!", (Object)this.packId, (Object)e);
        }
    }

    @Override
    public void disposeOfTexturePack(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            this.texturePackThumbnailTexture.delete();
            this.texturePackThumbnailTexture = null;
        }
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackThumbnailTexture == null) {
            this.texturePackThumbnailTexture = minecraft.textureManager.loadBufferedTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.textureManager.bindTexture(this.texturePackThumbnailTexture);
        } else {
            minecraft.textureManager.loadTexture("/assets/minecraft/textures/gui/unknown_pack.png").bind();
        }
    }

    @Override
    public boolean hasFile(String file) {
        try {
            boolean a;
            InputStream stream = TexturePackDefault.class.getResourceAsStream(file);
            boolean bl = a = stream != null;
            if (stream != null) {
                stream.close();
            }
            return a;
        }
        catch (Exception e) {
            return false;
        }
    }
}

