/*
 * Decompiled with CFR 0.152.
 */
package org.libsdl;

import java.util.Objects;
import org.libsdl.SDL;
import org.libsdl.SDL_Error;
import org.libsdl.SDL_JoystickID;

public final class SDL_Joystick {
    public long ptr;
    public final float AXIS_MIN;
    public final float AXIS_MAX;
    public final SDL_JoystickID instanceID;

    SDL_Joystick(long ptr) {
        this.ptr = ptr;
        this.instanceID = new SDL_JoystickID(SDL.SDL_JoystickInstanceID(ptr));
        this.AXIS_MAX = SDL.SDL_JOYSTICK_AXIS_MAX();
        this.AXIS_MIN = SDL.SDL_JOYSTICK_AXIS_MIN();
    }

    public static boolean eventStateQuery() throws SDL_Error {
        return SDL_Joystick.eventState(-1);
    }

    public static boolean eventStateIgnore() throws SDL_Error {
        return SDL_Joystick.eventState(0);
    }

    public static boolean eventStateEnable() throws SDL_Error {
        return SDL_Joystick.eventState(1);
    }

    private static boolean eventState(int i) throws SDL_Error {
        switch (SDL.SDL_JoystickEventState(i)) {
            case 1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new SDL_Error();
    }

    public static SDL_Joystick joystickFromInstanceID(SDL_JoystickID joyid) {
        return new SDL_Joystick(SDL.SDL_JoystickFromInstanceID(joyid.id));
    }

    public static String joystickNameForIndex(int device_index) {
        return SDL.SDL_JoystickNameForIndex(device_index);
    }

    public static SDL_Joystick JoystickOpen(int i) {
        return new SDL_Joystick(SDL.SDL_JoystickOpen(i));
    }

    public static void joystickUpdate() {
        SDL.SDL_JoystickUpdate();
    }

    public static int numJoysticks() throws SDL_Error {
        int num = SDL.SDL_NumJoysticks();
        if (num >= 0) {
            return num;
        }
        throw new SDL_Error();
    }

    public boolean getAttached() {
        return this.ptr != 0L && SDL.SDL_JoystickGetAttached(this.ptr);
    }

    public float getAxis(int axis) {
        if (!this.getAttached()) {
            return 0.0f;
        }
        int i = SDL.SDL_JoystickGetAxis(this.ptr, axis);
        if (i < 0) {
            return (float)i / -this.AXIS_MIN;
        }
        return (float)i / this.AXIS_MAX;
    }

    public boolean getButton(int button) {
        return this.getAttached() && SDL.SDL_JoystickGetButton(this.ptr, button) == 1;
    }

    public int currentPowerLevel() {
        return SDL.SDL_JoystickCurrentPowerLevel(this.ptr);
    }

    public int getHat(int hat) {
        if (!this.getAttached()) {
            return 0;
        }
        return SDL.SDL_JoystickGetHat(this.ptr, hat);
    }

    public SDL_JoystickID instanceID() {
        return this.instanceID;
    }

    public String name() {
        if (!this.getAttached()) {
            return "unAttached";
        }
        return SDL.SDL_JoystickName(this.ptr);
    }

    public int numAxes() throws SDL_Error {
        if (!this.getAttached()) {
            throw new SDL_Error();
        }
        int num = SDL.SDL_JoystickNumAxes(this.ptr);
        if (num >= 0) {
            return num;
        }
        throw new SDL_Error();
    }

    public int numButtons() throws SDL_Error {
        if (!this.getAttached()) {
            throw new SDL_Error();
        }
        int num = SDL.SDL_JoystickNumButtons(this.ptr);
        if (num >= 0) {
            return num;
        }
        throw new SDL_Error();
    }

    public int numBalls() throws SDL_Error {
        if (!this.getAttached()) {
            throw new SDL_Error();
        }
        int num = SDL.SDL_JoystickNumBalls(this.ptr);
        if (num >= 0) {
            return num;
        }
        throw new SDL_Error();
    }

    public int numHats() throws SDL_Error {
        if (!this.getAttached()) {
            throw new SDL_Error();
        }
        int num = SDL.SDL_JoystickNumHats(this.ptr);
        if (num >= 0) {
            return num;
        }
        throw new SDL_Error();
    }

    public void close() {
        if (this.getAttached()) {
            SDL.SDL_JoystickClose(this.ptr);
            this.ptr = 0L;
        }
    }

    public String GUID() {
        if (!this.getAttached()) {
            return "unAttached";
        }
        return SDL.SDL_JoystickGUIDString(this.ptr);
    }

    public static int productVersion(int device_index) {
        return SDL.SDL_JoystickGetDeviceProductVersion(device_index);
    }

    public boolean rumble(float leftMagnitude, float rightMagnitude, int duration_ms) {
        boolean rightInRange;
        if (!this.getAttached()) {
            return false;
        }
        boolean leftInRange = leftMagnitude >= 0.0f && leftMagnitude <= 1.0f;
        boolean bl = rightInRange = rightMagnitude >= 0.0f && rightMagnitude <= 1.0f;
        if (!leftInRange || !rightInRange) {
            throw new IllegalArgumentException("The passed values are not in the range 0 to 1!");
        }
        return SDL.SDL_JoystickRumble(this.ptr, (int)(65535.0f * leftMagnitude), (int)(65535.0f * rightMagnitude), duration_ms);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SDL_Joystick that = (SDL_Joystick)o;
        return this.ptr == that.ptr;
    }

    public int hashCode() {
        return Objects.hash(this.ptr);
    }
}

