/*
 * Decompiled with CFR 0.152.
 */
package net.betterthanadventure.sound;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import net.betterthanadventure.sound.ChannelLWJGL3OpenAL;
import net.betterthanadventure.sound.SourceLWJGL3OpenAL;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;

public class LibraryLWJGL3OpenAL
extends Library {
    private static final boolean GET = false;
    private static final boolean SET = true;
    private static final boolean XXX = false;
    private long device = -1L;
    private long context = -1L;
    private FloatBuffer listenerPositionAL = null;
    private FloatBuffer listenerOrientation = null;
    private FloatBuffer listenerVelocity = null;
    private Map<String, IntBuffer> ALBufferMap = new HashMap<String, IntBuffer>();
    private static boolean alPitchSupported = true;

    private void create() {
        this.device = ALC10.alcOpenDevice((ByteBuffer)null);
        if (this.device == 0L) {
            this.errorMessage("OpenAL device could not be created.");
            return;
        }
        ALCCapabilities deviceCaps = ALC.createCapabilities((long)this.device);
        this.context = ALC10.alcCreateContext((long)this.device, (IntBuffer)null);
        if (this.context == 0L) {
            this.errorMessage("OpenAL context could not be created.");
        }
        ALC10.alcMakeContextCurrent((long)this.context);
        AL.createCapabilities((ALCCapabilities)deviceCaps);
    }

    private void destroy() {
        if (this.context != 0L) {
            ALC10.alcDestroyContext((long)this.context);
            this.context = 0L;
        }
        if (this.device != 0L) {
            ALC10.alcCloseDevice((long)this.device);
            this.device = 0L;
        }
    }

    public void init() {
        boolean var1 = false;
        this.create();
        var1 = this.checkALError();
        if (var1) {
            this.importantMessage("OpenAL did not initialize properly!");
        } else {
            this.message("OpenAL initialized.");
        }
        this.listenerPositionAL = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.listener.position.x, this.listener.position.y, this.listener.position.z});
        this.listenerOrientation = BufferUtils.createFloatBuffer((int)6).put(new float[]{this.listener.lookAt.x, this.listener.lookAt.y, this.listener.lookAt.z, this.listener.up.x, this.listener.up.y, this.listener.up.z});
        this.listenerVelocity = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
        this.listenerPositionAL.flip();
        this.listenerOrientation.flip();
        this.listenerVelocity.flip();
        AL10.alListenerfv((int)4100, (FloatBuffer)this.listenerPositionAL);
        var1 = this.checkALError() || var1;
        AL10.alListenerfv((int)4111, (FloatBuffer)this.listenerOrientation);
        var1 = this.checkALError() || var1;
        AL10.alListenerfv((int)4102, (FloatBuffer)this.listenerVelocity);
        boolean bl = var1 = this.checkALError() || var1;
        if (var1) {
            this.importantMessage("OpenAL did not initialize properly!");
        } else {
            super.init();
            ChannelLWJGL3OpenAL var2 = (ChannelLWJGL3OpenAL)((Object)this.normalChannels.get(1));
            try {
                AL10.alSourcef((int)var2.ALSource.get(0), (int)4099, (float)1.0f);
                if (this.checkALError()) {
                    LibraryLWJGL3OpenAL.alPitchSupported(true, false);
                    throw new SoundSystemException("OpenAL: AL_PITCH not supported.", 13);
                }
                LibraryLWJGL3OpenAL.alPitchSupported(true, true);
            }
            catch (Exception var4) {
                LibraryLWJGL3OpenAL.alPitchSupported(true, false);
            }
        }
    }

    public static boolean libraryCompatible() {
        return true;
    }

    protected Channel createChannel(int var1) {
        IntBuffer var3 = BufferUtils.createIntBuffer((int)1);
        try {
            AL10.alGenSources((IntBuffer)var3);
        }
        catch (Exception var5) {
            AL10.alGetError();
            return null;
        }
        if (AL10.alGetError() != 0) {
            return null;
        }
        return new ChannelLWJGL3OpenAL(var1, var3);
    }

    public void cleanup() {
        super.cleanup();
        Set var1 = this.bufferMap.keySet();
        for (String var3 : var1) {
            IntBuffer var4 = this.ALBufferMap.get(var3);
            if (var4 == null) continue;
            AL10.alDeleteBuffers((IntBuffer)var4);
            this.checkALError();
            var4.clear();
        }
        this.bufferMap.clear();
        this.destroy();
        this.bufferMap = null;
        this.listenerPositionAL = null;
        this.listenerOrientation = null;
        this.listenerVelocity = null;
    }

    public boolean loadSound(FilenameURL var1) {
        int var8;
        if (this.bufferMap == null) {
            this.bufferMap = new HashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.ALBufferMap == null) {
            this.ALBufferMap = new HashMap<String, IntBuffer>();
            this.importantMessage("Open AL Buffer Map was null in method'loadSound'");
        }
        if (this.errorCheck(var1 == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(var1.getFilename()) != null) {
            return true;
        }
        ICodec var2 = SoundSystemConfig.getCodec((String)var1.getFilename());
        if (this.errorCheck(var2 == null, "No codec found for file '" + var1.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        var2.initialize(var1.getURL());
        SoundBuffer var3 = var2.readAll();
        var2.cleanup();
        var2 = null;
        if (this.errorCheck(var3 == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(var1.getFilename(), var3);
        AudioFormat var4 = var3.audioFormat;
        boolean var5 = false;
        if (var4.getChannels() == 1) {
            if (var4.getSampleSizeInBits() == 8) {
                var8 = 4352;
            } else {
                if (var4.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                var8 = 4353;
            }
        } else {
            if (var4.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (var4.getSampleSizeInBits() == 8) {
                var8 = 4354;
            } else {
                if (var4.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                var8 = 4355;
            }
        }
        IntBuffer var6 = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)var6);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when loading " + var1.getFilename())) {
            return false;
        }
        ByteBuffer var7 = BufferUtils.createByteBuffer((int)var3.audioData.length);
        var7.clear();
        var7.put(var3.audioData);
        var7.flip();
        AL10.alBufferData((int)var6.get(0), (int)var8, (ByteBuffer)var7, (int)((int)var4.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when loading " + var1.getFilename()) && this.errorCheck(var6 == null, "Sound buffer was not created for " + var1.getFilename())) {
            return false;
        }
        this.ALBufferMap.put(var1.getFilename(), var6);
        return true;
    }

    public void unloadSound(String var1) {
        this.ALBufferMap.remove(var1);
        super.unloadSound(var1);
    }

    public void setMasterVolume(float var1) {
        super.setMasterVolume(var1);
        AL10.alListenerf((int)4106, (float)var1);
        this.checkALError();
    }

    public void newSource(boolean var1, boolean var2, boolean var3, String var4, FilenameURL var5, float var6, float var7, float var8, int var9, float var10) {
        IntBuffer var11 = null;
        if (!var2) {
            var11 = this.ALBufferMap.get(var5.getFilename());
            if (var11 == null && !this.loadSound(var5)) {
                this.errorMessage("Source '" + var4 + "' was not created because an error occurred while loading " + var5.getFilename());
                return;
            }
            var11 = this.ALBufferMap.get(var5.getFilename());
            if (var11 == null) {
                this.errorMessage("Source '" + var4 + "' was not created because a sound buffer was not found for " + var5.getFilename());
                return;
            }
        }
        SoundBuffer var12 = null;
        if (!var2) {
            var12 = (SoundBuffer)this.bufferMap.get(var5.getFilename());
            if (var12 == null && !this.loadSound(var5)) {
                this.errorMessage("Source '" + var4 + "' was not created because an error occurred while loading " + var5.getFilename());
                return;
            }
            var12 = (SoundBuffer)this.bufferMap.get(var5.getFilename());
            if (var12 == null) {
                this.errorMessage("Source '" + var4 + "' was not created because audio data was not found for " + var5.getFilename());
                return;
            }
        }
        this.sourceMap.put(var4, new SourceLWJGL3OpenAL(this.listenerPositionAL, var11, var1, var2, var3, var4, var5, var12, var6, var7, var8, var9, var10, false));
    }

    public void rawDataStream(AudioFormat var1, boolean var2, String var3, float var4, float var5, float var6, int var7, float var8) {
        this.sourceMap.put(var3, new SourceLWJGL3OpenAL(this.listenerPositionAL, var1, var2, var3, var4, var5, var6, var7, var8));
    }

    public void quickPlay(boolean var1, boolean var2, boolean var3, String var4, FilenameURL var5, float var6, float var7, float var8, int var9, float var10, boolean var11) {
        IntBuffer var12 = null;
        if (!var2) {
            var12 = this.ALBufferMap.get(var5.getFilename());
            if (var12 == null) {
                this.loadSound(var5);
            }
            if ((var12 = this.ALBufferMap.get(var5.getFilename())) == null) {
                this.errorMessage("Sound buffer was not created for " + var5.getFilename());
                return;
            }
        }
        SoundBuffer var13 = null;
        if (!var2) {
            var13 = (SoundBuffer)this.bufferMap.get(var5.getFilename());
            if (var13 == null && !this.loadSound(var5)) {
                this.errorMessage("Source '" + var4 + "' was not created because an error occurred while loading " + var5.getFilename());
                return;
            }
            var13 = (SoundBuffer)this.bufferMap.get(var5.getFilename());
            if (var13 == null) {
                this.errorMessage("Source '" + var4 + "' was not created because audio data was not found for " + var5.getFilename());
                return;
            }
        }
        SourceLWJGL3OpenAL var14 = new SourceLWJGL3OpenAL(this.listenerPositionAL, var12, var1, var2, var3, var4, var5, var13, var6, var7, var8, var9, var10, false);
        this.sourceMap.put(var4, var14);
        this.play(var14);
        if (var11) {
            var14.setTemporary(true);
        }
    }

    public void copySources(HashMap var1) {
        if (var1 != null) {
            Set var2 = var1.keySet();
            Iterator var3 = var2.iterator();
            if (this.bufferMap == null) {
                this.bufferMap = new HashMap();
                this.importantMessage("Buffer Map was null in method 'copySources'");
            }
            if (this.ALBufferMap == null) {
                this.ALBufferMap = new HashMap<String, IntBuffer>();
                this.importantMessage("Open AL Buffer Map was null in method'copySources'");
            }
            this.sourceMap.clear();
            while (true) {
                if (!var3.hasNext()) {
                    return;
                }
                String var4 = (String)var3.next();
                Source var5 = (Source)var1.get(var4);
                if (var5 == null) continue;
                SoundBuffer var6 = null;
                if (!var5.toStream) {
                    this.loadSound(var5.filenameURL);
                    var6 = (SoundBuffer)this.bufferMap.get(var5.filenameURL.getFilename());
                }
                if (!var5.toStream && var6 == null) continue;
                this.sourceMap.put(var4, new SourceLWJGL3OpenAL(this.listenerPositionAL, this.ALBufferMap.get(var5.filenameURL.getFilename()), var5, var6));
            }
        }
    }

    public void setListenerPosition(float var1, float var2, float var3) {
        super.setListenerPosition(var1, var2, var3);
        this.listenerPositionAL.put(0, var1);
        this.listenerPositionAL.put(1, var2);
        this.listenerPositionAL.put(2, var3);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.listenerPositionAL);
        this.checkALError();
    }

    public void setListenerAngle(float var1) {
        super.setListenerAngle(var1);
        this.listenerOrientation.put(0, this.listener.lookAt.x);
        this.listenerOrientation.put(2, this.listener.lookAt.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
    }

    public void setListenerOrientation(float var1, float var2, float var3, float var4, float var5, float var6) {
        super.setListenerOrientation(var1, var2, var3, var4, var5, var6);
        this.listenerOrientation.put(0, var1);
        this.listenerOrientation.put(1, var2);
        this.listenerOrientation.put(2, var3);
        this.listenerOrientation.put(3, var4);
        this.listenerOrientation.put(4, var5);
        this.listenerOrientation.put(5, var6);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
    }

    public void setListenerData(ListenerData var1) {
        super.setListenerData(var1);
        this.listenerPositionAL.put(0, var1.position.x);
        this.listenerPositionAL.put(1, var1.position.y);
        this.listenerPositionAL.put(2, var1.position.z);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.listenerPositionAL);
        this.listenerOrientation.put(0, var1.lookAt.x);
        this.listenerOrientation.put(1, var1.lookAt.y);
        this.listenerOrientation.put(2, var1.lookAt.z);
        this.listenerOrientation.put(3, var1.up.x);
        this.listenerOrientation.put(4, var1.up.y);
        this.listenerOrientation.put(5, var1.up.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.listenerOrientation);
        this.checkALError();
    }

    private boolean checkALError() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter.");
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter.");
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value.");
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call.");
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory.");
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred.");
        return true;
    }

    public static boolean alPitchSupported() {
        return LibraryLWJGL3OpenAL.alPitchSupported(false, false);
    }

    private static synchronized boolean alPitchSupported(boolean var0, boolean var1) {
        if (var0) {
            alPitchSupported = var1;
        }
        return alPitchSupported;
    }

    public static String getTitle() {
        return "LWJGL OpenAL";
    }

    public static String getDescription() {
        return "The LWJGL3 binding of OpenAL.  For more information, see http://www.lwjgl.org";
    }

    public String getClassName() {
        return "LibraryLWJGL3OpenAL";
    }
}

