/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.meta;

import com.b100.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.texture.meta.AnimationProperties;
import net.minecraft.client.render.texture.meta.AnimationPropertiesAdapter;
import net.minecraft.client.render.texture.meta.TextureProperties;
import net.minecraft.client.render.texture.meta.TexturePropertiesAdapter;
import net.minecraft.client.render.texture.meta.gui.GuiTextureProperties;
import net.minecraft.client.render.texture.meta.gui.GuiTexturePropertiesAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class TextureMetaHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Gson GSON;
    @Nullable
    private JsonObject metaJson = null;
    @NotNull
    private final Map<String, Object> cachedData = new HashMap<String, Object>();

    public void reset() {
        this.metaJson = null;
        this.cachedData.clear();
    }

    public void loadFromStream(InputStream stream) throws JsonParseException {
        String jsonString;
        try {
            jsonString = StringUtils.readInputString(stream);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read json string from stream!", e);
            return;
        }
        this.metaJson = JsonParser.parseString(jsonString).getAsJsonObject();
    }

    public boolean has(String key) {
        return this.cachedData.containsKey(key) || this.metaJson != null && this.metaJson.has(key);
    }

    @Nullable
    public <T> T get(String key, Class<T> aClass) {
        Object o;
        if (this.cachedData.containsKey(key) && (o = this.cachedData.get(key)).getClass().isAssignableFrom(aClass)) {
            return (T)this.cachedData.get(key);
        }
        if (this.metaJson != null && this.metaJson.has(key)) {
            T obj = GSON.fromJson(this.metaJson.get(key), aClass);
            this.cachedData.put(key, obj);
            return obj;
        }
        return null;
    }

    public <T> T getOrDefault(String key, T metaDefault, Class<T> aClass) {
        Object o;
        if (this.cachedData.containsKey(key) && (o = this.cachedData.get(key)).getClass().isAssignableFrom(aClass)) {
            return (T)this.cachedData.get(key);
        }
        if (this.metaJson != null && this.metaJson.has(key)) {
            T obj = GSON.fromJson(this.metaJson.get(key), aClass);
            this.cachedData.put(key, obj);
            return obj;
        }
        return metaDefault;
    }

    public String toString() {
        if (this.metaJson == null) {
            return null;
        }
        return GSON.toJson(this.metaJson);
    }

    static {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.registerTypeAdapter((Type)((Object)TextureProperties.class), new TexturePropertiesAdapter());
        builder.registerTypeAdapter((Type)((Object)AnimationProperties.class), new AnimationPropertiesAdapter());
        builder.registerTypeAdapter((Type)((Object)GuiTextureProperties.class), new GuiTexturePropertiesAdapter());
        GSON = builder.create();
    }
}

