/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.util.collection;

public class LongHashMap<V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private transient Entry<V>[] table = new Entry[16];
    private transient int size;
    private int threshold = 12;
    private final float loadFactor;
    private volatile transient int modCount;

    public LongHashMap() {
        this.loadFactor = 0.75f;
    }

    private static int hash(long n) {
        return LongHashMap.hash((int)(n ^ n >>> 32));
    }

    private static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V get(long n) {
        Entry<V> next = this.table[LongHashMap.indexFor(LongHashMap.hash(n), this.table.length)];
        while (next != null) {
            if (next.key == n) {
                return next.value;
            }
            next = next.next;
        }
        return null;
    }

    public boolean containsKey(long n) {
        return this.getEntry(n) != null;
    }

    final Entry<V> getEntry(long n) {
        Entry<V> next = this.table[LongHashMap.indexFor(LongHashMap.hash(n), this.table.length)];
        while (next != null) {
            if (next.key == n) {
                return next;
            }
            next = next.next;
        }
        return null;
    }

    public void put(long n, V value) {
        int hash = LongHashMap.hash(n);
        int index = LongHashMap.indexFor(hash, this.table.length);
        Entry<V> next = this.table[index];
        while (next != null) {
            if (next.key == n) {
                next.value = value;
            }
            next = next.next;
        }
        ++this.modCount;
        this.addEntry(hash, n, value, index);
    }

    private void resize(int n) {
        if (this.table.length == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] table = new Entry[n];
        this.transfer(table);
        this.table = table;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    private void transfer(Entry<V>[] array) {
        Entry<V>[] table = this.table;
        int length = array.length;
        for (int i = 0; i < table.length; ++i) {
            Entry next;
            Entry<V> entry = table[i];
            if (entry == null) continue;
            table[i] = null;
            do {
                next = entry.next;
                int index = LongHashMap.indexFor(entry.hash, length);
                entry.next = array[index];
                array[index] = entry;
            } while ((entry = next) != null);
        }
    }

    public V remove(long n) {
        Entry<V> removeEntryForKey = this.removeEntryForKey(n);
        return removeEntryForKey == null ? null : (V)removeEntryForKey.value;
    }

    final Entry<V> removeEntryForKey(long n) {
        Entry<V> entry2;
        int index = LongHashMap.indexFor(LongHashMap.hash(n), this.table.length);
        Entry<V> entry = entry2 = this.table[index];
        while (entry2 != null) {
            Entry next = entry2.next;
            if (entry2.key == n) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[index] = next;
                } else {
                    entry.next = next;
                }
                return entry2;
            }
            entry = entry2;
            entry2 = next;
        }
        return entry2;
    }

    public void clear() {
        ++this.modCount;
        Entry<V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            table[i] = null;
        }
        this.size = 0;
    }

    public boolean containsValue(Object o) {
        if (o == null) {
            return this.containsNullValue();
        }
        Entry<V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            Entry<V> next = table[i];
            while (next != null) {
                if (o.equals(next.value)) {
                    return true;
                }
                next = next.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<V>[] table = this.table;
        for (int i = 0; i < table.length; ++i) {
            Entry<V> next = table[i];
            while (next != null) {
                if (next.value == null) {
                    return true;
                }
                next = next.next;
            }
        }
        return false;
    }

    private void addEntry(int n, long n2, V v, int n3) {
        this.table[n3] = new Entry<V>(n, n2, v, this.table[n3]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    private static class Entry<V> {
        final long key;
        V value;
        Entry<V> next;
        final int hash;

        Entry(int hash, long key, V value, Entry<V> next) {
            this.value = value;
            this.next = next;
            this.key = key;
            this.hash = hash;
        }

        public final long getKey() {
            return this.key;
        }

        public final V getValue() {
            return this.value;
        }

        public final boolean equals(Object o) {
            V value4;
            V value3;
            Long value2;
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            Long value = this.getKey();
            return (value == (value2 = Long.valueOf(entry.getKey())) || value != null && value.equals(value2)) && ((value3 = this.getValue()) == (value4 = entry.getValue()) || value3 != null && value3.equals(value4));
        }

        public final int hashCode() {
            return LongHashMap.hash(this.key);
        }

        public final String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

