/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.console.shell;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BindManager {
    @NotNull
    private static final BindManager INSTANCE = new BindManager();
    @NotNull
    private @NotNull Map<@NotNull Integer, @NotNull Runnable> keyToRunnableMap = new HashMap<Integer, Runnable>();

    @NotNull
    public static BindManager getInstance() {
        return INSTANCE;
    }

    @NotNull
    public @NotNull Collection<@NotNull Integer> getKeys() {
        return this.keyToRunnableMap.keySet();
    }

    @Nullable
    public Runnable getActionForKey(int key) {
        if (this.keyToRunnableMap.containsKey(key)) {
            return this.keyToRunnableMap.get(key);
        }
        return null;
    }

    public void bindKeyToAction(int key, @Nullable Runnable action) {
        if (action == null) {
            this.keyToRunnableMap.remove(key);
        } else {
            this.keyToRunnableMap.put(key, action);
        }
    }
}

