/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.ButtonElement;
import net.minecraft.client.gui.Screen;
import net.minecraft.client.gui.ScreenAddServer;
import net.minecraft.client.gui.ScreenConnectToIp;
import net.minecraft.client.gui.ScreenConnecting;
import net.minecraft.client.gui.ScrolledSelectionList;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.popup.PopupBuilder;
import net.minecraft.client.gui.popup.PopupScreen;
import net.minecraft.client.net.thread.ThreadPingServer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.SavedServerList;
import net.minecraft.core.net.ServerAddress;
import net.minecraft.core.net.ServerData;
import net.minecraft.core.util.helper.MathHelper;

public class ScreenSelectServer
extends Screen {
    protected String screenTitle = "Select server";
    private boolean selected = false;
    private int selectedServer;
    private SavedServerList savedServerList;
    private ServerSlot worldSlotContainer;
    private boolean deleting;
    public ButtonElement buttonConnect;
    public ButtonElement buttonDirectConnect;
    public ButtonElement buttonAdd;
    public ButtonElement buttonEdit;
    public ButtonElement buttonDelete;
    public ButtonElement buttonRefresh;
    public ButtonElement buttonCancel;
    TooltipElement tooltip;
    private Map<ServerData, ThreadPingServer> pingThreads = new HashMap<ServerData, ThreadPingServer>();

    public ScreenSelectServer(Screen parent) {
        super(parent);
    }

    @Override
    public void init() {
        I18n stringtranslate = I18n.getInstance();
        this.screenTitle = stringtranslate.translateKey("gui.select_server.label.title");
        this.loadSavedServers();
        this.worldSlotContainer = new ServerSlot();
        this.tooltip = new TooltipElement(this.mc);
        this.initButtons();
        this.refresh();
    }

    private void loadSavedServers() {
        this.savedServerList = SavedServerList.readFromFile(new File(Global.accessor.getMinecraftDir() + "/servers.dat"));
        this.selectedServer = -1;
    }

    public void initButtons() {
        I18n trans = I18n.getInstance();
        int x1 = this.width / 2 - 154;
        int y1 = this.height - 52;
        int y2 = this.height - 28;
        this.buttonConnect = this.add(new ButtonElement(0, x1, y1, 100, 20, trans.translateKey("gui.select_server.button.join_server")));
        this.buttonDirectConnect = this.add(new ButtonElement(0, x1 + 104, y1, 100, 20, trans.translateKey("gui.select_server.button.direct_connect")));
        this.buttonAdd = this.add(new ButtonElement(0, x1 + 208, y1, 100, 20, trans.translateKey("gui.select_server.button.add_server")));
        this.buttonEdit = this.add(new ButtonElement(0, x1, y2, 74, 20, trans.translateKey("gui.select_server.button.edit")));
        this.buttonDelete = this.add(new ButtonElement(0, x1 + 78, y2, 74, 20, trans.translateKey("gui.select_server.button.delete")));
        this.buttonRefresh = this.add(new ButtonElement(0, x1 + 156, y2, 74, 20, trans.translateKey("gui.select_server.button.refresh")));
        this.buttonCancel = this.add(new ButtonElement(0, x1 + 234, y2, 74, 20, trans.translateKey("gui.select_server.button.cancel")));
        this.setButtonsEnabled(false);
    }

    @Override
    protected void buttonClicked(ButtonElement button) {
        ServerData serverData;
        if (!button.enabled) {
            return;
        }
        if (button == this.buttonDelete) {
            String serverName = this.savedServerList.servers.get((int)this.selectedServer).nickname;
            if (serverName != null) {
                this.deleting = true;
                I18n i18n = I18n.getInstance();
                PopupScreen popup = new PopupBuilder(this, 250).closeOnEsc(0).withLabel("gui.select_server.label.delete_title").withLabel("gui.select_server.label.delete_confirm.1").withLabelLiteral(i18n.translateKeyAndFormat("gui.select_server.label.delete_confirm.2", serverName)).withLabelLiteral("").withButtonGroup("endButtons", new String[]{"gui.select_server.button.delete", "gui.select_server.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                    if (statusCode == 1) {
                        this.deleteWorld(true, this.selectedServer);
                    }
                }).build();
                this.mc.displayScreen(popup);
            }
        } else if (button == this.buttonConnect) {
            this.selectServer(this.selectedServer);
        } else if (button == this.buttonDirectConnect) {
            this.mc.displayScreen(new ScreenConnectToIp(this));
        } else if (button == this.buttonAdd) {
            this.mc.displayScreen(new ScreenAddServer(this, this.savedServerList));
            this.savedServerList.writeToFile();
        } else if (button == this.buttonCancel) {
            this.mc.displayScreen(this.parentScreen);
        } else if (button == this.buttonRefresh) {
            this.refresh();
        } else if (button == this.buttonEdit && (serverData = this.savedServerList.servers.get(this.selectedServer)) != null) {
            PopupScreen popup = new PopupBuilder(this, 140).closeOnEsc(0).closeOnClickOut(0).closeOnEnter(1).withLabel("gui.select_server.label.edit.1").withLabel("gui.select_server.label.edit.2").withTextField("nameField", serverData.nickname).withLabel("gui.select_server.label.edit.3").withTextField("ipField", serverData.address).withButton("showIp", "gui.select_server.button.show_ip", serverData.showIp ? 0 : 1, "gui.select_server.button.show_ip.on", "gui.select_server.button.show_ip.off").withButtonGroup("endButtons", new String[]{"gui.select_server.button.done", "gui.select_server.button.cancel"}, new int[]{1, 0}).withOnCloseListener((statusCode, results) -> {
                if (statusCode == 1) {
                    serverData.nickname = (String)results.get("nameField");
                    serverData.address = (String)results.get("ipField");
                    serverData.showIp = (Integer)results.get("showIp") == 0;
                    this.savedServerList.writeToFile();
                    this.refresh();
                }
            }).build();
            this.mc.displayScreen(popup);
        }
    }

    public void handleIncomingServerInfo(ServerData server) {
        this.pingThreads.remove(server);
    }

    public void refresh() {
        this.selectedServer = -1;
        this.loadSavedServers();
        this.setButtonsEnabled(false);
        for (ServerData server : this.savedServerList.servers) {
            if (this.pingThreads.containsKey(server) && !this.pingThreads.get(server).isDone()) continue;
            ThreadPingServer tps = new ThreadPingServer(this, server);
            this.pingThreads.put(server, tps);
            tps.start();
        }
    }

    @Override
    public void tick() {
        super.tick();
        try {
            for (ThreadPingServer tps : this.pingThreads.values()) {
                if (!tps.isDone()) continue;
                tps.tickNetClientHandler();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ServerData server : this.savedServerList.servers) {
            ThreadPingServer tps = this.pingThreads.get(server);
            if (tps == null || !tps.isDone() || tps.getNetHandler() != null) continue;
            server.isUp = false;
            this.pingThreads.remove(server);
        }
    }

    public void setButtonsEnabled(boolean selected) {
        this.buttonConnect.enabled = selected;
        this.buttonDelete.enabled = selected;
        this.buttonEdit.enabled = selected;
    }

    public void selectServer(int i) {
        this.mc.displayScreen(null);
        if (this.selected) {
            return;
        }
        this.selected = true;
        ServerData server = this.savedServerList.servers.get(this.selectedServer);
        ServerAddress address = server.getServerAddress();
        this.mc.displayScreen(new ScreenConnecting(this.mc, address.getIP(), address.getPort()));
    }

    public void deleteWorld(boolean flag, int i) {
        if (this.deleting) {
            this.deleting = false;
            if (flag) {
                this.savedServerList.servers.remove(i);
                this.savedServerList.writeToFile();
            }
            this.mc.displayScreen(this);
        }
    }

    @Override
    public void render(int mx, int my, float partialTick) {
        this.worldSlotContainer.render(mx, my, partialTick);
        this.drawStringCentered(this.font, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        super.render(mx, my, partialTick);
    }

    class ServerSlot
    extends ScrolledSelectionList {
        public ServerSlot() {
            super(ScreenSelectServer.this.mc, ScreenSelectServer.this.width, ScreenSelectServer.this.height, 32, ScreenSelectServer.this.height - 64, 36);
        }

        @Override
        protected int getItemCount() {
            return ((ScreenSelectServer)ScreenSelectServer.this).savedServerList.servers.size();
        }

        @Override
        protected void selectItem(int itemIndex, boolean doubleClicked) {
            ScreenSelectServer.this.selectedServer = itemIndex;
            boolean enableButtons = ScreenSelectServer.this.selectedServer >= 0 && ScreenSelectServer.this.selectedServer < this.getItemCount();
            ScreenSelectServer.this.setButtonsEnabled(enableButtons);
            if (doubleClicked && enableButtons) {
                ScreenSelectServer.this.selectServer(itemIndex);
            }
        }

        @Override
        protected boolean isSelectedItem(int itemIndex) {
            return itemIndex == ScreenSelectServer.this.selectedServer;
        }

        @Override
        protected int getMaxPosition() {
            return ((ScreenSelectServer)ScreenSelectServer.this).savedServerList.servers.size() * 36;
        }

        @Override
        protected void renderHoleBackground() {
            ScreenSelectServer.this.renderBackground();
        }

        @Override
        protected void renderItem(int index, int x, int y, int height, Tessellator tessellator) {
            ServerData server = ((ScreenSelectServer)ScreenSelectServer.this).savedServerList.servers.get(index);
            String line1 = server.nickname;
            String line2 = server.address;
            ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, line1, x + 2, y + 1, 0xFFFFFF);
            if (server.showIp) {
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, line2, x + 2, y + 12 + 10, 0x404040);
            }
            if (server.isUp && server.protocolVersion != 29728) {
                String outdated = I18n.getInstance().translateKey("gui.select_server.label.outdated");
                int width = ScreenSelectServer.this.font.getStringWidth(outdated);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, outdated, x + 220 - width - 4, y + 1, 0xFF0000);
                width = ScreenSelectServer.this.font.getStringWidth(server.version);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, server.version, x + 220 - width - 4, y + 12, 0xFF0000);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, server.motd, x + 2, y + 12, 0x808080);
            } else if (server.isUp) {
                String latency = server.latency + "ms";
                int width = ScreenSelectServer.this.font.getStringWidth(latency);
                float green = 1.0f - MathHelper.clamp((float)server.latency / 500.0f, 0.0f, 1.0f);
                float red = 1.0f - green;
                int argb = 0xFF000000 | (int)(255.0f * red) << 16 | (int)(255.0f * green) << 8;
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, latency, x + 220 - width - 4, y + 1, argb);
                String players = server.currentPlayers + "/" + server.maxPlayers;
                width = ScreenSelectServer.this.font.getStringWidth(players);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, players, x + 220 - width - 4, y + 12, 0x808080);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, server.motd, x + 2, y + 12, 0x808080);
            } else {
                String down = I18n.getInstance().translateKey("gui.select_server.label.down");
                int width = ScreenSelectServer.this.font.getStringWidth(down);
                ScreenSelectServer.this.drawString(ScreenSelectServer.this.font, down, x + 220 - width - 4, y + 1, 0xFF0000);
            }
        }
    }
}

