/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.popup;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.TextFieldElement;
import net.minecraft.client.gui.popup.InteractivePopupComponent;
import net.minecraft.client.gui.popup.PopupScreen;

public class TextInputComponent
extends InteractivePopupComponent<String> {
    private final TextFieldElement textField;

    public TextInputComponent(int width, String defaultText, String placeholder) {
        super(width);
        this.textField = new TextFieldElement(null, Minecraft.getMinecraft().font, 0, 0, width, this.getHeight(), defaultText, placeholder);
    }

    @Override
    public void setParent(PopupScreen parent) {
        super.setParent(parent);
        this.textField.parent = parent;
    }

    @Override
    public String getOutput() {
        return this.textField.getText();
    }

    @Override
    public int getHeight() {
        return 20;
    }

    @Override
    public void render(int x, int y, int mouseX, int mouseY) {
        this.textField.xPosition = x;
        this.textField.yPosition = y;
        this.textField.drawTextBox();
        this.textField.updateCursor(Minecraft.getMinecraft(), mouseX, mouseY);
    }

    @Override
    public void onClick(int x, int y, int button) {
        this.textField.mouseClicked(x, y, button);
    }

    @Override
    public void onKeyDown(int keyCode, char c) {
        this.textField.textboxKeyTyped(c, keyCode);
    }

    @Override
    public void tick() {
        this.textField.updateCursorCounter();
    }
}

