/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.glfw.GlfwGamepad;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Logger;

public abstract class InputHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Minecraft minecraft;
    public static ControllerInput[] controllers;

    public static void init(Minecraft minecraft) throws Exception {
        InputHandler.minecraft = minecraft;
        try {
            InputHandler.initGLFW(minecraft);
        }
        catch (Throwable e) {
            LOGGER.error("Could not initialize GLFW controllers.");
            e.printStackTrace();
        }
    }

    public static void poll() {
        if (!InputHandler.minecraft.gameWindow.isFocused()) {
            return;
        }
        for (int i = 0; i < 15; ++i) {
            ControllerInput input;
            if (controllers[i] != null) {
                if (!controllers[i].getController().isPresent()) {
                    InputHandler.disconnected(controllers[i]);
                    InputHandler.controllers[i] = null;
                    continue;
                }
                controllers[i].getController().poll();
                if (!controllers[i].hasAnyInput()) continue;
                InputHandler.minecraft.controllerInput = controllers[i];
                minecraft.setInputType(InputType.CONTROLLER);
                continue;
            }
            if (!GLFW.glfwJoystickPresent((int)i) || !GLFW.glfwJoystickIsGamepad((int)i)) continue;
            GlfwGamepad gamepad = new GlfwGamepad(i);
            InputHandler.controllers[i] = input = new ControllerInput(minecraft, gamepad);
            InputHandler.connected(input);
        }
    }

    private static void connected(ControllerInput controller) {
        LOGGER.info("Controller connected: {}", (Object)controller.getGUID());
        InputHandler.minecraft.controllerInput = controller;
    }

    private static void disconnected(ControllerInput controller) {
        LOGGER.info("Controller disconnected: {}", (Object)controller.getGUID());
        if (InputHandler.minecraft.controllerInput == controller) {
            minecraft.setInputType(InputType.KEYBOARD);
            InputHandler.minecraft.controllerInput = null;
        }
    }

    public static void initGLFW(Minecraft minecraft) throws Throwable {
        int found = 0;
        for (int i = 0; i < 15; ++i) {
            ControllerInput input;
            if (!GLFW.glfwJoystickPresent((int)i) || !GLFW.glfwJoystickIsGamepad((int)i)) continue;
            GlfwGamepad gamepad = new GlfwGamepad(i);
            InputHandler.controllers[i] = input = new ControllerInput(minecraft, gamepad);
            ++found;
        }
        LOGGER.info("{} controllers found!", (Object)found);
    }

    public static ControllerInput getController(String guid) {
        try {
            for (ControllerInput controllerInput : controllers) {
                if (!controllerInput.getGUID().equalsIgnoreCase(guid)) continue;
                return controllerInput;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        controllers = new ControllerInput[16];
    }
}

