/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import net.minecraft.client.input.controller.Button;
import net.minecraft.client.input.controller.IJoystickListener;
import net.minecraft.client.option.OptionFloat;

public class Joystick {
    public int xAxis;
    public int yAxis;
    public IJoystickListener joystickListener;
    public final String name;
    public final Button button;
    private OptionFloat deadzone;
    private float x;
    private float y;
    private boolean moving = false;
    private boolean moveLastFrame = false;

    public Joystick(String name, int xAxis, int yAxis, IJoystickListener joystickListener, Button button, OptionFloat deadzone) {
        this.name = name;
        this.deadzone = deadzone;
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        this.joystickListener = joystickListener;
        this.button = button;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public Button getButton() {
        return this.button;
    }

    public void update() {
        boolean inDeadzone;
        this.button.update();
        float x = this.joystickListener.getValue(this.xAxis);
        float y = this.joystickListener.getValue(this.yAxis);
        float length = (float)Math.sqrt(x * x + y * y);
        boolean bl = inDeadzone = length < ((Float)this.deadzone.value).floatValue();
        if (inDeadzone) {
            x = 0.0f;
            y = 0.0f;
        }
        this.x = x;
        this.y = y;
        this.moveLastFrame = this.moving;
        this.moving = !inDeadzone;
    }

    public boolean stoppedMoving() {
        return this.moveLastFrame && !this.moving;
    }
}

