/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.block.model.BlockModelTorch;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogicRepeater;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockModelRepeater
extends BlockModelStandard<BlockLogicRepeater> {
    private static final BlockModelTorch<?> modelTorchActive = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Blocks.TORCH_REDSTONE_ACTIVE);
    private static final BlockModelTorch<?> modelTorchIdle = (BlockModelTorch)BlockModelDispatcher.getInstance().getDispatch(Blocks.TORCH_REDSTONE_IDLE);

    public BlockModelRepeater(Block<BlockLogicRepeater> block) {
        super(block);
    }

    @Override
    public boolean render(@NotNull Tessellator tessellator, @NotNull WorldSource worldSource, int x, int y, int z) {
        BlockModelTorch<?> modelTorch;
        int meta = worldSource.getBlockMetadata(x, y, z);
        int i1 = meta & 3;
        switch (i1) {
            case 0: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 0;
                break;
            }
            case 2: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 3;
                break;
            }
            case 3: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 2;
                break;
            }
            case 1: {
                BlockModelRepeater.renderBlocks.uvRotateTop = 1;
            }
        }
        int j1 = (meta & 0xC) >> 2;
        renderBlocks.renderStandardBlock(tessellator, worldSource, this, this.block.getBlockBoundsFromState(worldSource, x, y, z), x, y, z);
        renderBlocks.resetRenderBlocks();
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            int lmc = this.block.getLightmapCoord(worldSource, x, y, z);
            if (this.block.emission > 0) {
                lmc = LightmapHelper.setBlocklightValue(lmc, 15);
            }
            tessellator.setLightmapCoord(lmc);
        } else {
            brightness = renderBlocks.getBlockBrightness(worldSource, x, y, z);
            if (this.block.emission > 0 || Global.accessor.isFullbrightEnabled()) {
                brightness = 1.0f;
            }
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = -0.1875;
        double d1 = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        switch (i1) {
            case 0: {
                d4 = -0.3125;
                d2 = BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 2: {
                d4 = 0.3125;
                d2 = -BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 3: {
                d3 = -0.3125;
                d1 = BlockLogicRepeater.torchPosOffset[j1];
                break;
            }
            case 1: {
                d3 = 0.3125;
                d1 = -BlockLogicRepeater.torchPosOffset[j1];
            }
        }
        BlockModelTorch<?> blockModelTorch = modelTorch = ((BlockLogicRepeater)this.block.getLogic()).isRepeaterPowered ? modelTorchActive : modelTorchIdle;
        if (BlockModelRepeater.renderBlocks.overbright && ((BlockLogicRepeater)this.block.getLogic()).isRepeaterPowered) {
            modelTorch.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d, (double)z + d2, 0.0, 0.0);
            modelTorch.renderTorchAtAngle(tessellator, (double)x + d3, (double)y + d, (double)z + d4, 0.0, 0.0);
        } else if (!BlockModelRepeater.renderBlocks.overbright) {
            modelTorch.renderTorchAtAngle(tessellator, (double)x + d1, (double)y + d, (double)z + d2, 0.0, 0.0);
            modelTorch.renderTorchAtAngle(tessellator, (double)x + d3, (double)y + d, (double)z + d4, 0.0, 0.0);
        }
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public boolean shouldSideBeRendered(WorldSource blockAccess, AABB bounds, int x, int y, int z, @NotNull Side side) {
        return true;
    }
}

