/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.entity.player.PlayerLocal;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.MobRendererBiped;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.entity.IItemHolding;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class MobRendererBipedArmored<T extends Mob>
extends MobRendererBiped<T> {
    protected ModelBiped modelArmorA;
    protected ModelBiped modelArmorB;

    public MobRendererBipedArmored(ModelBiped model, float shadowSize) {
        this(model, new ModelBiped(1.0f), new ModelBiped(0.5f), shadowSize);
    }

    public MobRendererBipedArmored(ModelBiped model, ModelBiped modelArmorA, ModelBiped modelArmorB, float shadowSize) {
        super(model, shadowSize);
        this.modelArmorA = modelArmorA;
        this.modelArmorB = modelArmorB;
    }

    @Override
    protected void renderAdditional(T entity, float partialTick) {
        @Nullable ItemStack stack = ((IArmorWearing)entity).getItemInArmorSlot(HumanArmorShape.HEAD);
        if (stack != null) {
            GL11.glPushMatrix();
            this.modelBipedMain.head.translateTo(0.0625f);
            if (!(stack.getItem() instanceof IArmorItem)) {
                GL11.glPushMatrix();
                GL11.glEnable((int)2884);
                GL11.glScalef((float)-0.6f, (float)-0.6f, (float)0.6f);
                GL11.glTranslatef((float)0.0f, (float)0.4375f, (float)0.0f);
                ItemModelDispatcher.getInstance().getDispatch(stack).render(Tessellator.instance, null, stack, "head", true, 1, LightmapHelper.isLightmapEnabled() ? 1.0f : ((Entity)entity).getBrightness(partialTick), 1.0f, partialTick, true);
                GL11.glDisable((int)2884);
                GL11.glPopMatrix();
            }
            GL11.glPopMatrix();
        }
        super.renderAdditional(entity, partialTick);
    }

    @Override
    public void render(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (entity instanceof IItemHolding) {
            ItemStack itemstack = ((IItemHolding)entity).getHeldItem();
            if (((IItemHolding)entity).isLeftHanded()) {
                this.modelArmorB.holdingLeftHand = this.modelBipedMain.holdingLeftHand = this.modelBipedMain.holdingLeftHand | itemstack != null;
                this.modelArmorA.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
            } else {
                this.modelArmorB.holdingRightHand = this.modelBipedMain.holdingRightHand = this.modelBipedMain.holdingRightHand | itemstack != null;
                this.modelArmorA.holdingRightHand = this.modelBipedMain.holdingRightHand;
            }
        }
        this.modelArmorB.sneaking = this.modelBipedMain.sneaking = ((Entity)entity).isSneaking();
        this.modelArmorA.sneaking = this.modelBipedMain.sneaking;
        this.modelArmorB.isRiding = this.modelBipedMain.isRiding = ((Entity)entity).isPassenger();
        this.modelArmorA.isRiding = this.modelBipedMain.isRiding;
        double realY = y - (double)((Mob)entity).heightOffset;
        if (((Entity)entity).isSneaking() && !(entity instanceof PlayerLocal)) {
            realY -= 0.125;
        }
        super.render(tessellator, entity, x, realY, z, yaw, partialTick);
        this.modelBipedMain.holdingLarge = false;
        this.modelArmorB.holdingLarge = false;
        this.modelArmorA.holdingLarge = false;
        this.modelBipedMain.sneaking = false;
        this.modelArmorB.sneaking = false;
        this.modelArmorA.sneaking = false;
        this.modelBipedMain.holdingRightHand = false;
        this.modelArmorB.holdingRightHand = false;
        this.modelArmorA.holdingRightHand = false;
        this.modelBipedMain.holdingLeftHand = false;
        this.modelArmorB.holdingLeftHand = false;
        this.modelArmorA.holdingLeftHand = false;
        GL11.glDisable((int)3042);
    }

    @Override
    protected boolean prepareArmor(T entity, int layer, float partialTick) {
        ItemStack itemstack = ((IArmorWearing)entity).getItemInArmorSlot(HumanArmorShape.values()[((IArmorWearing)entity).getNumArmorSlots() - 1 - layer]);
        if (itemstack != null) {
            Item item = itemstack.getItem();
            if (item instanceof ItemQuiver) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver.png");
                ModelBiped modelBiped = this.modelArmorA;
                modelBiped.body.visible = layer == 1 || layer == 2;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (item instanceof ItemQuiverEndless) {
                this.bindTexture("/assets/minecraft/textures/armor/quiver_golden.png");
                ModelBiped modelBiped = this.modelArmorA;
                modelBiped.body.visible = layer == 1 || layer == 2;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (item == Items.ARMOR_BOOTS_ICESKATES) {
                this.bindTexture("/assets/minecraft/textures/armor/skates.png");
                ModelBiped modelBiped = this.modelArmorA;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                this.setArmorModel(modelBiped);
                return true;
            }
            if (item instanceof IArmorItem && ((IArmorItem)((Object)item)).getArmorMaterial() != null) {
                IArmorItem armorItem = (IArmorItem)((Object)item);
                this.bindTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace, armorItem.getArmorMaterial().identifier.value, layer != 2 ? 1 : 2));
                ModelBiped modelBiped = layer != 2 ? this.modelArmorA : this.modelArmorB;
                modelBiped.head.visible = layer == 0;
                modelBiped.hair.visible = layer == 0;
                modelBiped.body.visible = layer == 1 || layer == 2;
                modelBiped.armRight.visible = layer == 1;
                modelBiped.armLeft.visible = layer == 1;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                this.setArmorModel(modelBiped);
                return true;
            }
        }
        return false;
    }
}

