/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.Lighting;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.PlayerSkinParser;
import net.minecraft.client.render.TileEntityRenderDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.EntityCamera;
import net.minecraft.client.render.entity.MobRendererBipedArmored;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.model.ModelPlayerSlim;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.Global;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.motion.CarriedBlock;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.player.gamemode.Gamemode;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.BlocksContainer;
import org.lwjgl.opengl.GL11;

public class MobRendererPlayer
extends MobRendererBipedArmored<Player> {
    private final ModelPlayer modelThick = new ModelPlayer(0.0f);
    private final ModelPlayer modelSlim = new ModelPlayerSlim(0.0f);
    private BlocksContainer container = null;

    public MobRendererPlayer() {
        super(new ModelPlayer(0.0f), 0.5f);
    }

    public void drawFirstPersonHand(Player player, boolean isLeft) {
        this.mainModel = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = player.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain.swingProgress = 0.0f;
        this.modelBipedMain.isRiding = false;
        this.modelBipedMain.setupAnimation(player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, 1.0f);
        if (isLeft) {
            this.modelBipedMain.armLeft.render(0.0625f);
        } else {
            this.modelBipedMain.armRight.render(0.0625f);
        }
        if (this.modelBipedMain instanceof ModelPlayer) {
            if (isLeft) {
                ((ModelPlayer)this.modelBipedMain).bipedLeftArmOverlay.render(0.0625f);
            } else {
                ((ModelPlayer)this.modelBipedMain).bipedRightArmOverlay.render(0.0625f);
            }
        }
    }

    public void drawHeldObject(Player player, float partialTick) {
        if (player.getHeldObject() instanceof CarriedBlock) {
            CarriedBlock carriedBlock = (CarriedBlock)player.getHeldObject();
            if (this.container == null || this.container.world != player.world) {
                this.container = new BlocksContainer(player.world);
            }
            Tessellator tessellator = Tessellator.instance;
            Minecraft mc = Minecraft.getMinecraft();
            TextureRegistry.blockAtlas.bind();
            GL11.glPushMatrix();
            Lighting.disable();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3042);
            GL11.glDisable((int)2884);
            if (mc.isAmbientOcclusionEnabled()) {
                GL11.glShadeModel((int)7425);
            } else {
                GL11.glShadeModel((int)7424);
            }
            GL11.glScalef((float)0.55f, (float)-0.55f, (float)0.55f);
            GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)-0.75f);
            int blockX = MathHelper.floor(player.x);
            int blockY = MathHelper.floor(player.y) + 1;
            int blockZ = MathHelper.floor(player.z);
            tessellator.startDrawingQuads();
            tessellator.setTranslation((double)(-blockX) - 0.5, (double)(-blockY) - 0.5, (double)(-blockZ) - 0.5);
            this.container.setLightReferenceEntity(player);
            this.container.setBlock(blockX, blockY, blockZ, carriedBlock.blockId, carriedBlock.metadata, carriedBlock.entity);
            ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(carriedBlock.block())).renderNoCulling(Tessellator.instance, this.container, blockX, blockY, blockZ);
            tessellator.draw();
            tessellator.setTranslation(0.0, 0.0, 0.0);
            this.container.setLightReferenceEntity(null);
            this.container.clear();
            TileEntityRenderer<TileEntity> renderer = TileEntityRenderDispatcher.instance.getRenderer(carriedBlock.entity);
            if (renderer != null) {
                carriedBlock.entity.worldObj = player.world;
                renderer.doRender(tessellator, carriedBlock.entity, -0.5, -0.5, -0.5, partialTick);
                carriedBlock.entity.worldObj = null;
            }
            Lighting.enableLight();
            GL11.glPopMatrix();
        }
    }

    @Override
    protected void renderSpecials(Tessellator tessellator, Player entity, double x, double y, double z) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() != Gamemode.spectator && entity.getGamemode() == Gamemode.spectator) {
            return;
        }
        if (Minecraft.getMinecraft().gameSettings.immersiveMode.drawNames() && this.renderDispatcher.camera != null) {
            float f3;
            if (this.renderDispatcher.camera instanceof EntityCamera && ((EntityCamera)this.renderDispatcher.camera).mob == entity) {
                return;
            }
            float f = 1.6f;
            float f1 = 0.01666667f * f;
            float f2 = (float)this.renderDispatcher.camera.distanceTo(entity);
            float f4 = f3 = entity.isSneaking() ? 32.0f : 64.0f;
            if (f2 < f3) {
                String s = entity.getDisplayName();
                if (!entity.isSneaking()) {
                    if (entity.isPlayerSleeping()) {
                        this.renderLivingLabel(tessellator, entity, s, x, y - 1.5, z, 64, false);
                    } else {
                        this.renderLivingLabel(tessellator, entity, s, x, y, z, 64, false);
                    }
                } else {
                    Font font = this.getFont();
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + 2.3f), (float)((float)z));
                    GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.renderDispatcher.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glScalef((float)(-f1), (float)(-f1), (float)f1);
                    GL11.glDisable((int)2896);
                    GL11.glTranslatef((float)0.0f, (float)(0.25f / f1), (float)0.0f);
                    GL11.glDepthMask((boolean)false);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)770, (int)771);
                    GL11.glDisable((int)3553);
                    tessellator.startDrawingQuads();
                    int i = font.getStringWidth(s) / 2;
                    tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
                    tessellator.addVertex(-i - 1, -1.0, 0.0);
                    tessellator.addVertex(-i - 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, 8.0, 0.0);
                    tessellator.addVertex(i + 1, -1.0, 0.0);
                    tessellator.draw();
                    GL11.glEnable((int)3553);
                    GL11.glDepthMask((boolean)true);
                    font.drawString(s, -font.getStringWidth(s) / 2, 0, 0x20FFFFFF);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GL11.glPopMatrix();
                }
            }
        }
    }

    @Override
    protected void setupScale(Player entity, float partialTick) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() == Gamemode.spectator && entity.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        } else if (entity.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
        float scale = 0.9375f;
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        if (entity.isDwarf()) {
            GL11.glScalef((float)0.6f, (float)0.5f, (float)0.6f);
        }
    }

    @Override
    protected void renderAdditional(Player player, float partialTick) {
        if (Minecraft.getMinecraft().thePlayer.getGamemode() == Gamemode.spectator && player.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.25f);
        } else if (player.getGamemode() == Gamemode.spectator) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.0f);
        }
        super.renderAdditional(player, partialTick);
        boolean renderCape = this.bindDownloadableTexture("https://api.betterthanadventure.net/capes?username=" + player.username, null, null);
        if (!renderCape) {
            renderCape = this.bindDownloadableTexture(player.capeURL, null, null);
        }
        if (renderCape) {
            GL11.glPushMatrix();
            float brightness = Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled() ? 1.0f : player.getBrightness(partialTick);
            GL11.glColor4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)0.125f);
            float yawOff = player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialTick;
            float bodyAngle = 5.0f;
            if (player.isSneaking()) {
                bodyAngle += 25.0f;
            }
            double _xd = player.xdO + (player.xd - player.xdO) * (double)partialTick;
            double _yd = Math.min(player.ydO + (player.yd - player.ydO) * (double)partialTick, 0.0);
            double _zd = player.zd0 + (player.zd - player.zd0) * (double)partialTick;
            double vel = -1.0 / (3.0 * Math.hypot(_xd, _zd) + 1.0) + 1.0;
            double moveAng = Math.atan2(_xd, _zd);
            double yawRad = Math.toRadians(yawOff);
            double multiplier = 1.0 - Math.abs((Math.cos(yawRad) + 1.0 - (Math.cos(moveAng) + 1.0) + 2.0) / 2.0 - 1.0);
            player.wobbleTimer += (float)((double)((float)player.tickCount + partialTick - (float)player.lastRenderTick) / (30.0 - 29.0 * MathHelper.clamp(vel, 0.0, 1.0)));
            player.lastRenderTick = player.tickCount;
            double wobble = Math.sin(player.wobbleTimer) * (1.5 + 4.5 * vel * multiplier);
            GL11.glRotatef((float)((float)MathHelper.clamp(MathHelper.clamp((double)bodyAngle + vel * 100.0 * multiplier, (double)bodyAngle, 100.0) + wobble - _yd * 60.0, 0.0, 180.0)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.modelBipedMain.renderCloak(0.0625f);
            GL11.glPopMatrix();
        }
        if (player.getHeldObject() != null) {
            float walkSpeed = player.walkAnimSpeedO + (player.walkAnimSpeed - player.walkAnimSpeedO) * partialTick;
            float walkProgress = player.walkAnimPos - player.walkAnimSpeed * (1.0f - partialTick);
            GL11.glTranslatef((float)0.0f, (float)(MathHelper.cos(walkProgress / 2.0f * 2.0f / 3.0f) / 26.0f * walkSpeed + 0.1f), (float)0.0f);
            this.drawHeldObject(player, partialTick);
        }
    }

    @Override
    protected void setupRotations(Player entity, float ticksExisted, float bodyYaw, float partialTick) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            GL11.glRotatef((float)entity.getBedOrientationInDegrees(), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.getMaxDeathRotation(entity), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else {
            super.setupRotations(entity, ticksExisted, bodyYaw, partialTick);
        }
    }

    @Override
    protected void translateModel(Player entity, double x, double y, double z) {
        if (entity.isAlive() && entity.isPlayerSleeping()) {
            super.translateModel(entity, x + (double)entity.sleepOffX, y + (double)entity.sleepOffY, z + (double)entity.sleepOffZ);
        } else {
            super.translateModel(entity, x, y, z);
        }
    }

    @Override
    public void render(Tessellator tessellator, Player entity, double x, double y, double z, float yaw, float partialTick) {
        this.mainModel = entity.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain = entity.slimModel ? this.modelSlim : this.modelThick;
        this.modelBipedMain.holdingLarge = entity.getHeldObject() != null;
        this.modelArmorB.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelArmorA.holdingLarge = this.modelBipedMain.holdingLarge;
        this.modelArmorB.holdingRightHand = this.modelBipedMain.holdingRightHand = this.modelBipedMain.holdingRightHand | entity.getHeldObject() != null;
        this.modelArmorA.holdingRightHand = this.modelBipedMain.holdingRightHand;
        this.modelArmorB.holdingLeftHand = this.modelBipedMain.holdingLeftHand = this.modelBipedMain.holdingLeftHand | entity.getHeldObject() != null;
        this.modelArmorA.holdingLeftHand = this.modelBipedMain.holdingLeftHand;
        super.render(tessellator, entity, x, y, z, yaw, partialTick);
    }

    @Override
    public void loadEntityTexture(Player entity) {
        this.bindDownloadableTexture(entity.skinURL, entity.getEntityTexture(), PlayerSkinParser.instance);
    }
}

