/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.texture.stitcher;

import com.mojang.logging.LogUtils;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.customatlas.CustomAtlasHandler;
import net.minecraft.client.render.texture.Texture;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.client.render.texturepack.TexturePack;
import net.minecraft.client.util.helper.Textures;
import net.minecraft.core.util.collection.NamespaceID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class AtlasStitcher
extends Texture {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String rootAssetPath = "/assets";
    public Map<NamespaceID, IconCoordinate> textureMap = new HashMap<NamespaceID, IconCoordinate>();
    public BufferedImage atlas;
    public final String directoryPath;
    @Nullable
    public final String defaultTexture;
    private int atlasWidth;
    private int atlasHeight;
    private double invWidth;
    private double invHeight;
    private final boolean mipmap;
    private final boolean tickPaused;

    public AtlasStitcher(String directoryPath, boolean tickWhenPaused, boolean mipmap, @Nullable String defaultTexture) {
        this.directoryPath = directoryPath;
        this.tickPaused = tickWhenPaused;
        this.mipmap = mipmap;
        this.defaultTexture = defaultTexture;
    }

    protected IconCoordinate getTexture(@NotNull NamespaceID sourceId, @NotNull NamespaceID id) {
        if (this.textureMap.containsKey(id)) {
            return this.textureMap.get(id);
        }
        IconCoordinate iconCoordinate = new IconCoordinate(this, sourceId, id, this.getSourceImagePath(id));
        this.textureMap.put(id, iconCoordinate);
        return iconCoordinate;
    }

    public String getSourceImagePath(@NotNull NamespaceID id) {
        return String.format("%s/%s/%s/%s.png", rootAssetPath, id.namespace, this.directoryPath, id.value);
    }

    public void preinit() {
        this.generate();
        long startTime = System.nanoTime();
        Minecraft mc = Minecraft.getMinecraft();
        ArrayList<IconCoordinate> coordinateList = new ArrayList<IconCoordinate>(this.textureMap.values());
        ArrayList<Future<IconCoordinate>> futures = new ArrayList<Future<IconCoordinate>>();
        ExecutorService service = Executors.newFixedThreadPool(32);
        for (IconCoordinate iconCoordinate : coordinateList) {
            futures.add(service.submit(new SetupTexture(mc, iconCoordinate, this.defaultTexture)));
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("", e);
            }
        }
        service.shutdown();
        LOGGER.debug("Took '{}' seconds to load images.", (Object)((double)(System.nanoTime() - startTime) / 1.0E9));
    }

    @Override
    public void init() {
        int area = 0;
        int maxWidth = 0;
        ArrayList<IconCoordinate> coordinateList = new ArrayList<IconCoordinate>(this.textureMap.values());
        for (IconCoordinate coordinate : coordinateList) {
            if (coordinate.needsDimensions()) {
                BufferedImage image = coordinate.getImageStorage();
                coordinate.setDimension(image.getWidth(), image.getHeight());
            }
            area += coordinate.getArea();
            if (coordinate.width <= maxWidth) continue;
            maxWidth = coordinate.width;
        }
        int targetWidth = Integer.highestOneBit((int)Math.max(Math.ceil(Math.sqrt(area)), (double)maxWidth)) << 1;
        Collections.sort(coordinateList);
        int nextX = 0;
        int currentY = 0;
        int nextY = ((IconCoordinate)coordinateList.get((int)0)).height;
        int maxRealWidth = 0;
        for (IconCoordinate coordinate : coordinateList) {
            if (nextX + coordinate.width > targetWidth) {
                nextX = 0;
                currentY = nextY;
                nextY += coordinate.height;
            }
            coordinate.setPosition(nextX, currentY);
            if ((nextX += coordinate.width) <= maxRealWidth) continue;
            maxRealWidth = nextX;
        }
        BufferedImage generatedAtlas = new BufferedImage(targetWidth, Integer.highestOneBit(nextY) << 1, 2);
        Graphics2D atlas = generatedAtlas.createGraphics();
        atlas.setComposite(AlphaComposite.getInstance(3, 1.0f));
        for (IconCoordinate coordinate : coordinateList) {
            coordinate.drawToAtlas(atlas);
            coordinate.discardImage();
        }
        atlas.dispose();
        this.atlasWidth = generatedAtlas.getWidth();
        this.atlasHeight = generatedAtlas.getHeight();
        this.invWidth = 1.0 / (double)this.atlasWidth;
        this.invHeight = 1.0 / (double)this.atlasHeight;
        this.atlas = generatedAtlas;
        this.setupTexture(this.atlas, false, false, this.mipmap);
    }

    public int getAtlasWidth() {
        return this.atlasWidth;
    }

    public int getAtlasHeight() {
        return this.atlasHeight;
    }

    public double getInverseWidth() {
        return this.invWidth;
    }

    public double getInverseHeight() {
        return this.invHeight;
    }

    public boolean tickWhenPaused() {
        return this.tickPaused;
    }

    public boolean hasMipmaps() {
        return this.mipmap;
    }

    public static class SetupTexture
    implements Callable<IconCoordinate> {
        private final Minecraft mc;
        private final IconCoordinate coordinate;
        private final String defaultTexture;

        public SetupTexture(Minecraft mc, IconCoordinate coordinate, String defaultTexture) {
            this.mc = mc;
            this.coordinate = coordinate;
            this.defaultTexture = defaultTexture;
        }

        @Override
        public IconCoordinate call() {
            TexturePack pack;
            this.coordinate.resetMetadata();
            BufferedImage image = CustomAtlasHandler.getTextureOverride(this.mc.texturePackList, this.coordinate.sourceImage);
            if (image == null && (pack = this.mc.texturePackList.getHighestPriorityTexturePackWithFile(this.coordinate.sourceImage)) != null) {
                String metaPath;
                for (int attempt = 0; attempt < 3; ++attempt) {
                    try {
                        image = Textures.readImageUnhandled(pack.getResourceAsStream(this.coordinate.sourceImage));
                        if (image == null) continue;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("", e);
                    }
                }
                if (pack.hasFile(metaPath = this.coordinate.sourceImage + ".mcmeta")) {
                    try (InputStream stream = pack.getResourceAsStream(metaPath);){
                        this.coordinate.initMetadata(stream);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to initiate metadata for '{}'!", (Object)this.coordinate.namespaceId, (Object)e);
                    }
                }
            }
            if (image == null || image == Textures.missingTexture) {
                LOGGER.warn("{} could not be found!", (Object)this.coordinate.sourceImage);
                if (this.defaultTexture != null) {
                    image = Textures.readImage(this.mc.texturePackList.getResourceAsStream(this.defaultTexture));
                }
                if (image == null) {
                    image = Textures.missingTexture;
                }
            }
            this.coordinate.setImage(image);
            return this.coordinate;
        }
    }
}

