/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tileentity;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.render.item.model.ItemModelDispatcher;
import net.minecraft.client.render.model.ModelBiped;
import net.minecraft.client.render.model.ModelPigman;
import net.minecraft.client.render.model.ModelPlayer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.tileentity.TileEntityRenderer;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemQuiver;
import net.minecraft.core.item.ItemQuiverEndless;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;

public class TileEntityRendererStatue
extends TileEntityRenderer<TileEntityStatue> {
    @NotNull
    public static final @NotNull Map<@NotNull Block<?>, @NotNull String> BLOCK_SKIN_MAP = new HashMap();
    private final ModelPlayer model = new ModelPlayer(0.0f);
    private final ModelBiped modelArmorA;
    private final ModelBiped modelArmorB;
    private final ModelPigman modelPigman = new ModelPigman(0.0f, 0.0f);

    public TileEntityRendererStatue() {
        this.modelArmorA = new ModelBiped(1.0f);
        this.modelArmorB = new ModelBiped(0.5f);
    }

    private ModelBiped model(boolean isPigman) {
        if (isPigman) {
            return this.modelPigman;
        }
        return this.model;
    }

    public void renderAt(@Nullable ItemStack heldStack, int meta, @NotNull Block<?> lowerBlock, @NotNull TileEntityStatue.Pose pose, @Nullable IArmorWearing<HumanArmorShape> armorWearer, double x, double y, double z) {
        boolean isPigman = lowerBlock == Blocks.STATUE_PIGMAN_LOWER;
        GL12.glEnable((int)32826);
        float scale = 0.0625f;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.loadTexture(BLOCK_SKIN_MAP.getOrDefault(lowerBlock, BLOCK_SKIN_MAP.get(Blocks.STATUE_STONE_LOWER)));
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
        float rotation = (float)(meta * 360) / 16.0f;
        GL11.glRotatef((float)(-rotation), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glScalef((float)1.0f, (float)-1.0f, (float)-1.0f);
        GL11.glDisable((int)2884);
        GL11.glPushMatrix();
        GL11.glScalef((float)0.0625f, (float)0.0625f, (float)0.0625f);
        this.renderModel(this.model(isPigman), pose);
        if (armorWearer != null) {
            for (int i = 0; i < 4; ++i) {
                this.renderArmor(armorWearer, i, pose);
            }
        }
        GL11.glPopMatrix();
        this.renderHeldItem(heldStack, isPigman);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        GL12.glDisable((int)32826);
    }

    private void renderHeldItem(@Nullable ItemStack itemStack, boolean isPigman) {
        if (itemStack != null) {
            GL12.glEnable((int)32826);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.model((boolean)isPigman).armRight.translateTo(0.0625f);
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glScalef((float)-1.0f, (float)1.0f, (float)-1.0f);
            GL11.glTranslatef((float)0.0625f, (float)0.125f, (float)-0.625f);
            ItemModelDispatcher.getInstance().getDispatch(itemStack).render(Tessellator.instance, null, itemStack, "thirdperson_righthand", true, 1, 1.0f, 1.0f, 1.0f, false);
            GL11.glEnable((int)2884);
            GL12.glDisable((int)32826);
        }
    }

    private void applyPose(TileEntityStatue.Pose pose, ModelBiped model) {
        model.armLeft.xRot = pose.leftArmPitch;
        model.armRight.xRot = pose.rightArmPitch;
        model.legLeft.xRot = pose.leftLegPitch;
        model.legRight.xRot = pose.rightLegPitch;
        model.head.xRot = pose.headPitch;
        model.head.yRot = pose.headYaw;
        if (model instanceof ModelPigman) {
            ((ModelPigman)model).nose.xRot = pose.headPitch;
            ((ModelPigman)model).nose.yRot = pose.headYaw;
        }
    }

    private void renderModel(ModelBiped model, TileEntityStatue.Pose pose) {
        float scale = 1.0f;
        model.setupAnimation(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f);
        this.applyPose(pose, model);
        model.head.render(1.0f);
        model.body.render(1.0f);
        model.armRight.render(1.0f);
        model.armLeft.render(1.0f);
        model.legRight.render(1.0f);
        model.legLeft.render(1.0f);
        model.hair.render(1.0f);
        if (model instanceof ModelPigman) {
            ((ModelPigman)model).nose.render(1.0f);
        }
    }

    @Override
    public void doRender(Tessellator tessellator, TileEntityStatue tileEntity, double x, double y, double z, float partialTick) {
        this.renderAt(tileEntity.getHeldItem(), tileEntity.getBlockMeta(), tileEntity.getBlock(), tileEntity.getPose(), tileEntity, x, y, z);
    }

    private boolean renderArmor(@NotNull IArmorWearing<HumanArmorShape> armorWearer, int layer, TileEntityStatue.Pose pose) {
        ItemStack itemstack = armorWearer.getItemInArmorSlot(HumanArmorShape.values()[armorWearer.getNumArmorSlots() - 1 - layer]);
        if (itemstack != null) {
            ModelBiped modelBiped;
            Item item = itemstack.getItem();
            ModelBiped toDraw = null;
            if (item instanceof ItemQuiver) {
                this.loadTexture("/assets/minecraft/textures/armor/quiver.png");
                modelBiped = this.modelArmorA;
                modelBiped.body.visible = layer == 1 || layer == 2;
                toDraw = modelBiped;
            }
            if (item instanceof ItemQuiverEndless) {
                this.loadTexture("/assets/minecraft/textures/armor/quiver_golden.png");
                modelBiped = this.modelArmorA;
                modelBiped.body.visible = layer == 1 || layer == 2;
                toDraw = modelBiped;
            }
            if (item == Items.ARMOR_BOOTS_ICESKATES) {
                this.loadTexture("/assets/minecraft/textures/armor/skates.png");
                modelBiped = this.modelArmorA;
                modelBiped.legRight.visible = layer == 2 || layer == 3;
                modelBiped.legLeft.visible = layer == 2 || layer == 3;
                toDraw = modelBiped;
            }
            if (item instanceof IArmorItem && ((IArmorItem)((Object)item)).getArmorMaterial() != null) {
                IArmorItem armorItem = (IArmorItem)((Object)item);
                this.loadTexture(String.format("/assets/%s/textures/armor/%s_%d.png", armorItem.getArmorMaterial().identifier.namespace, armorItem.getArmorMaterial().identifier.value, layer != 2 ? 1 : 2));
                ModelBiped modelBiped2 = layer != 2 ? this.modelArmorA : this.modelArmorB;
                modelBiped2.head.visible = layer == 0;
                modelBiped2.hair.visible = layer == 0;
                modelBiped2.body.visible = layer == 1 || layer == 2;
                modelBiped2.armRight.visible = layer == 1;
                modelBiped2.armLeft.visible = layer == 1;
                modelBiped2.legRight.visible = layer == 2 || layer == 3;
                modelBiped2.legLeft.visible = layer == 2 || layer == 3;
                toDraw = modelBiped2;
            }
            if (toDraw != null) {
                this.renderModel(toDraw, pose);
                return true;
            }
        }
        return false;
    }

    static {
        @NotNull String basePath = "/assets/minecraft/textures/entity/statue/";
        BLOCK_SKIN_MAP.put(Blocks.STATUE_STONE_LOWER, "/assets/minecraft/textures/entity/statue/stone.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_BASALT_LOWER, "/assets/minecraft/textures/entity/statue/basalt.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_LIMESTONE_LOWER, "/assets/minecraft/textures/entity/statue/limestone.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_GRANITE_LOWER, "/assets/minecraft/textures/entity/statue/granite.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_MARBLE_LOWER, "/assets/minecraft/textures/entity/statue/marble.png");
        BLOCK_SKIN_MAP.put(Blocks.STATUE_PIGMAN_LOWER, "/assets/minecraft/textures/entity/statue/pigman.png");
    }
}

