/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLogic;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityStatue;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.enums.HumanArmorShape;
import net.minecraft.core.item.IArmorItem;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockLogicStatue
extends BlockLogic {
    private final boolean isBottom;
    public final @Nullable Supplier<@NotNull Item> droppedItem;

    public BlockLogicStatue(Block<?> block, Material material, boolean isBottom, @Nullable Supplier<Item> droppedItem) {
        super(block, material);
        this.isBottom = isBottom;
        this.droppedItem = droppedItem;
        if (isBottom) {
            block.withEntity(TileEntityStatue::new);
        }
        float bottom = this.isBottom ? 0.0f : -1.0f;
        float top = this.isBottom ? 2.0f : 1.0f;
        this.setBlockBounds(0.0, bottom, 0.0, 1.0, top, 1.0);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        boolean shouldInsertArmor;
        @Nullable TileEntityStatue statueEntity = this.getTileEntity(world, x, y, z);
        if (statueEntity == null) {
            return false;
        }
        if (player.isSneaking()) {
            statueEntity.nextPose();
            return true;
        }
        @Nullable HumanArmorShape interactSlot = side == Side.TOP || yHit >= 0.5 ? (this.isBottom ? HumanArmorShape.LEGS : HumanArmorShape.HEAD) : (side == Side.BOTTOM || yHit < 0.5 ? (this.isBottom ? HumanArmorShape.BOOTS : HumanArmorShape.CHEST) : null);
        @Nullable ItemStack statueHeldItemStack = statueEntity.getHeldItem();
        Item statueHeldItem = statueHeldItemStack != null ? statueHeldItemStack.getItem() : null;
        ItemStack statueArmorItemStack = interactSlot != null ? statueEntity.getItemInArmorSlot(interactSlot) : null;
        Item statueArmorItem = statueArmorItemStack != null ? statueArmorItemStack.getItem() : null;
        @Nullable ItemStack playerHeldItemStack = player.getHeldItem();
        Item playerHeldItem = playerHeldItemStack != null ? playerHeldItemStack.getItem() : null;
        boolean isPlayerHoldingArmor = playerHeldItem instanceof IArmorItem && ((IArmorItem)((Object)playerHeldItem)).getArmorShape() == interactSlot;
        boolean isPlayerHandEmpty = playerHeldItem == null;
        boolean isStatueHandEmpty = statueHeldItem == null;
        boolean isStatueArmorEmpty = statueArmorItem == null;
        boolean shouldTakeItem = !isStatueHandEmpty && !isPlayerHoldingArmor;
        boolean shouldInsertItem = !isPlayerHandEmpty && !isPlayerHoldingArmor;
        boolean shouldTakeArmor = interactSlot != null && !isStatueArmorEmpty && isStatueHandEmpty;
        boolean bl = shouldInsertArmor = interactSlot != null && isPlayerHoldingArmor;
        if (shouldTakeItem && shouldInsertItem) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                player.inventory.insertItem(statueHeldItemStack, true);
                statueEntity.setHeldItem(newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeItem) {
            player.inventory.insertItem(statueHeldItemStack, true);
            statueEntity.setHeldItem(null);
            return true;
        }
        if (shouldInsertItem) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                statueEntity.setHeldItem(newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeArmor && shouldInsertArmor) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                player.inventory.insertItem(statueArmorItemStack, true);
                statueEntity.setItemInArmorSlot(interactSlot, newStack);
                return true;
            }
            return false;
        }
        if (shouldTakeArmor) {
            player.inventory.insertItem(statueArmorItemStack, true);
            statueEntity.setItemInArmorSlot(interactSlot, (ItemStack)null);
            return true;
        }
        if (shouldInsertArmor) {
            if (playerHeldItemStack.consumeItem(player)) {
                @NotNull ItemStack newStack = playerHeldItemStack.copy();
                newStack.stackSize = 1;
                statueEntity.setItemInArmorSlot(interactSlot, newStack);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isCubeShaped() {
        return false;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Nullable
    public TileEntityStatue getTileEntity(@NotNull World world, int x, int y, int z) {
        @Nullable Block<?> block = world.getBlock(x, this.isBottom ? y : y - 1, z);
        if (block == null || !(block.getLogic() instanceof BlockLogicStatue)) {
            return null;
        }
        @Nullable TileEntity tileEntity = world.getTileEntity(x, this.isBottom ? y : y - 1, z);
        if (!(tileEntity instanceof TileEntityStatue)) {
            return null;
        }
        return (TileEntityStatue)tileEntity;
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (this.isBottom) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            @Nullable TileEntity tileEntity = world.getTileEntity(x, y, z);
            if (tileEntity != null) {
                TileEntityStatue statueEntity = (TileEntityStatue)tileEntity;
                for (HumanArmorShape armorShape : HumanArmorShape.values()) {
                    @Nullable ItemStack armorStack = statueEntity.getItemInArmorSlot(armorShape);
                    if (armorStack == null) continue;
                    stacks.add(armorStack);
                }
                @Nullable ItemStack heldItemStack = statueEntity.getHeldItem();
                if (heldItemStack != null) {
                    stacks.add(heldItemStack);
                }
            }
            for (ItemStack stack : stacks) {
                world.dropItem(x, y, z, stack);
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        Block<?> otherBlock = !this.isBottom ? Blocks.blocksList[world.getBlockId(x, y - 1, z)] : Blocks.blocksList[world.getBlockId(x, y + 1, z)];
        if (otherBlock == null || !(otherBlock.getLogic() instanceof BlockLogicStatue)) {
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        if (this.droppedItem == null) {
            return null;
        }
        if (dropCause != EnumDropCause.IMPROPER_TOOL) {
            return new ItemStack[]{new ItemStack(this.droppedItem.get())};
        }
        return null;
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (y >= world.getHeightBlocks() - 1) {
            return false;
        }
        return super.canPlaceBlockAt(world, x, y, z) && super.canPlaceBlockAt(world, x, y + 1, z);
    }

    @Override
    public int getPistonPushReaction(World world, int x, int y, int z) {
        return 1;
    }
}

