/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.nbt.tags;

import com.mojang.nbt.tags.Tag;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ShortArrayTag
extends Tag<short[]> {
    public ShortArrayTag() {
        this(new short[0]);
    }

    public ShortArrayTag(short[] array) {
        super(array);
    }

    @Override
    void write(@NotNull DataOutput dos) throws IOException {
        dos.writeInt(((short[])this.getValue()).length);
        byte[] bytes = new byte[((short[])this.getValue()).length * 2];
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().put((short[])this.getValue());
        dos.write(bytes);
    }

    @Override
    void read(@NotNull DataInput dis) throws IOException {
        int length = dis.readInt();
        this.setValue(new short[length]);
        byte[] bytes = new byte[length * 2];
        dis.readFully(bytes);
        ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).asShortBuffer().get((short[])this.getValue());
    }

    @Override
    public byte getId() {
        return 11;
    }

    public String toString() {
        if (((short[])this.getValue()).length > 16) {
            return "\"" + this.getTagName() + "\": [ " + ((short[])this.getValue()).length + " shorts ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.getTagName()).append("\": [ ");
        for (short s : (short[])this.getValue()) {
            sb.append(s).append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ShortArrayTag)) {
            return false;
        }
        ShortArrayTag otherTag = (ShortArrayTag)obj;
        short[] thisData = (short[])this.getValue();
        short[] otherData = (short[])otherTag.getValue();
        return Arrays.equals(thisData, otherData);
    }
}

