/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.chat;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.TooltipElement;
import net.minecraft.client.gui.chat.PositionSupplier;
import net.minecraft.client.gui.hud.component.ComponentAnchor;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.client.net.command.ClientCommandSource;
import net.minecraft.client.render.Font;
import net.minecraft.core.net.command.CommandManager;
import net.minecraft.core.net.command.CommandSource;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.command.util.CommandHelper;
import net.minecraft.core.net.packet.PacketRequestCommandManager;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.slf4j.Logger;

public class GuiElementChatSuggestions
extends Gui {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final TextFieldEditor editor;
    private final ITextField textField;
    private final Minecraft mc;
    private final Font fontRenderer;
    private final CommandSource commandSource;
    private final PositionSupplier<Integer> xSupplier;
    private final PositionSupplier<Integer> ySupplier;
    private ComponentAnchor anchor;
    @Nullable
    private ParseResults<CommandSource> parseResults;
    @Nullable
    private CompletableFuture<Suggestions> pendingSuggestions;
    private int commandIndex = -1;
    private String tablessMessage;
    private int tablessCursor;
    private List<Suggestion> suggestions = new ArrayList<Suggestion>();
    private int scroll = 0;
    TooltipElement tooltip;
    public static JsonObject serverSuggestions;
    private static final int MAX_SUGGESTIONS = 10;
    private static final boolean SUGGESTIONS_FOLLOW_PARAMETERS = true;
    private static final List<String> ARGUMENT_STYLES;
    public boolean hidden = false;

    public GuiElementChatSuggestions(Minecraft mc, TextFieldEditor textFieldEditor, ITextField textField, PositionSupplier<Integer> xSupplier, PositionSupplier<Integer> ySupplier, ComponentAnchor anchor) {
        this.mc = mc;
        this.xSupplier = xSupplier;
        this.ySupplier = ySupplier;
        this.anchor = anchor;
        this.fontRenderer = this.mc.font;
        this.commandSource = new ClientCommandSource(this.mc);
        this.editor = textFieldEditor;
        this.textField = textField;
        this.tablessMessage = this.textField.getText();
        this.tablessCursor = this.editor.getCursor();
        this.tooltip = new TooltipElement(this.mc);
        serverSuggestions = new JsonObject();
    }

    public CommandManager getManager() {
        return this.mc.currentWorld == null ? new CommandManager(false) : this.mc.currentWorld.getCommandManager();
    }

    public void drawScreen() {
        block10: {
            block12: {
                block11: {
                    block9: {
                        if (this.hidden) {
                            return;
                        }
                        if (this.suggestions.isEmpty()) break block9;
                        this.renderSuggestions(this.fontRenderer, this.tablessMessage, this.suggestions.get(0).getRange().getStart());
                        break block10;
                    }
                    if (this.parseResults == null) break block11;
                    if (!this.parseResults.getExceptions().isEmpty()) {
                        int i = 0;
                        for (Exception exception : this.parseResults.getExceptions().values()) {
                            this.renderSingleSuggestionLine(this.mc.font, TextFormatting.RED + exception.getMessage(), i, false);
                            ++i;
                        }
                    } else {
                        CommandSyntaxException parseException = CommandManager.getParseException(this.parseResults);
                        if (parseException != null) {
                            this.renderSingleSuggestionLine(this.mc.font, TextFormatting.RED + parseException.getMessage(), 0, false);
                        } else {
                            List<String> commandUsage = this.getCommandUsage(this.tablessCursor);
                            for (int i = 0; i < commandUsage.size(); ++i) {
                                this.renderSingleSuggestionLine(this.mc.font, TextFormatting.LIGHT_GRAY + commandUsage.get(i), i, true);
                            }
                        }
                    }
                    break block10;
                }
                if (serverSuggestions.isEmpty()) break block10;
                if (!serverSuggestions.has("o") || serverSuggestions.getAsJsonArray("o").isEmpty()) break block12;
                for (int i = 0; i < serverSuggestions.getAsJsonArray("o").size(); ++i) {
                    this.renderSingleSuggestionLine(this.mc.font, TextFormatting.LIGHT_GRAY + serverSuggestions.getAsJsonArray("o").get(i).getAsJsonObject().get("f").getAsString(), i, true);
                }
                break block10;
            }
            if (serverSuggestions.getAsJsonArray("n").isEmpty()) break block10;
            int i = 0;
            for (JsonElement jsonElement : serverSuggestions.getAsJsonArray("n")) {
                this.renderSingleSuggestionLine(this.mc.font, TextFormatting.RED + jsonElement.getAsJsonObject().get("f").getAsString(), i, false);
                ++i;
            }
        }
    }

    private void renderSuggestions(Font fontRenderer, String message, int start) {
        int mouseX = GuiElementChatSuggestions.getScaledMouseX(this.mc);
        int mouseY = GuiElementChatSuggestions.getScaledMouseY(this.mc) - 1;
        int leftMargin = this.xSupplier.get(this.textField, this, this.mc, true);
        int largestSuggestion = 0;
        for (Suggestion suggestion : this.suggestions) {
            if (fontRenderer.getStringWidth(suggestion.getText()) <= largestSuggestion) continue;
            largestSuggestion = fontRenderer.getStringWidth(suggestion.getText());
        }
        int minY = this.ySupplier.get(this.textField, this, this.mc, true);
        int suggestionBoxHeight = Math.min(this.suggestions.size(), 10) * 12;
        this.drawRect(leftMargin -= (int)(this.anchor.xPosition * (float)(largestSuggestion + 2)), minY += (int)CommandHelper.linearInterpolation(this.anchor.yPosition, 1.0f, -suggestionBoxHeight - 1), largestSuggestion + leftMargin + 1, minY + suggestionBoxHeight, Integer.MIN_VALUE);
        if (this.scroll < this.suggestions.size() - 10) {
            GuiElementChatSuggestions.drawDottedRect(this, leftMargin, minY + suggestionBoxHeight, largestSuggestion + leftMargin + 1, minY + suggestionBoxHeight + 1, Color.WHITE.getRGB(), 1);
        }
        if (this.scroll != 0) {
            GuiElementChatSuggestions.drawDottedRect(this, leftMargin, minY - 1, largestSuggestion + leftMargin + 1, minY, Color.WHITE.getRGB(), 1);
        }
        for (int i = 0; i < Math.min(this.suggestions.size(), 10); ++i) {
            String suggestionText = this.suggestions.get(i + this.scroll).getText();
            int suggestionHeight = 12 * (-i + Math.min(this.suggestions.size(), 10) - 2) + 25;
            String colorCode = i + this.scroll == this.commandIndex || this.isHoveringOverSuggestions(mouseX, mouseY) && i + this.scroll == this.getIndexOfSuggestionBeingHoveredOver(mouseX, mouseY).get() ? TextFormatting.YELLOW.toString() : TextFormatting.LIGHT_GRAY.toString();
            int textX = (int)((float)(leftMargin + 1) + this.anchor.xPosition * (float)(largestSuggestion - fontRenderer.getStringWidth(suggestionText)));
            fontRenderer.drawStringWithShadow(colorCode + suggestionText, textX, minY + suggestionBoxHeight - suggestionHeight + 3, 0xE0E0E0);
        }
        if (this.isHoveringOverSuggestions(mouseX, mouseY) && this.suggestions.get(this.getIndexOfSuggestionBeingHoveredOver(mouseX, mouseY).get()).getTooltip() != null) {
            this.tooltip.render(this.suggestions.get(this.getIndexOfSuggestionBeingHoveredOver(mouseX, mouseY).get()).getTooltip().getString(), mouseX, mouseY, 0, 0);
        }
    }

    private void renderSingleSuggestionLine(Font fontRenderer, String text, int heightIndex, boolean followParameters) {
        int leftMargin = this.xSupplier.get(this.textField, this, this.mc, followParameters);
        int stringWidth = fontRenderer.getStringWidth(text);
        int minY = this.ySupplier.get(this.textField, this, this.mc, followParameters);
        this.drawRect(leftMargin -= (int)(this.anchor.xPosition * (float)(stringWidth + 2)), minY += (int)CommandHelper.linearInterpolation(this.anchor.yPosition, heightIndex * 12, -12 - heightIndex * 12), stringWidth + leftMargin + 1, minY + 12, Integer.MIN_VALUE);
        fontRenderer.drawStringWithShadow(text, leftMargin + 1, minY + 2, 0xE0E0E0);
    }

    private List<String> getCommandUsage(int cursor) {
        ArrayList<String> commandUsage = new ArrayList<String>();
        if (this.parseResults == null || this.parseResults.getContext().getRootNode() == null || this.parseResults.getContext().getRange().getStart() > cursor) {
            return commandUsage;
        }
        for (Map.Entry<CommandNode<CommandSource>, String> entry : this.getManager().getDispatcher().getSmartUsage(this.parseResults.getContext().findSuggestionContext((int)cursor).parent, this.commandSource).entrySet()) {
            if (entry.getKey() instanceof LiteralCommandNode) continue;
            commandUsage.add(entry.getValue());
        }
        return commandUsage;
    }

    public void keyTyped(char c, int key) {
        int mouseX = GuiElementChatSuggestions.getScaledMouseX(this.mc);
        int mouseY = GuiElementChatSuggestions.getScaledMouseY(this.mc) - 1;
        int TAB = 15;
        int LEFT_SHIFT = 42;
        if (key == TAB) {
            if (this.commandIndex == -1 && this.isHoveringOverSuggestions(mouseX, mouseY)) {
                this.cycleToSuggestion(this.getIndexOfSuggestionBeingHoveredOver(mouseX, mouseY).get());
            } else if (Keyboard.isKeyDown(LEFT_SHIFT)) {
                this.cycleThroughSuggestions(-1);
            } else {
                this.cycleThroughSuggestions();
            }
            return;
        }
        if (!this.shouldApplySuggestion(c, key)) {
            return;
        }
        this.updateSuggestions();
    }

    public void updateSuggestions() {
        this.resetAllManagerVariables();
        String text = this.editor.getText();
        int cursor = this.editor.getCursor();
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(text)) {
            this.parseResults = null;
        }
        StringReader stringReader = new StringReader(text);
        if (this.mc.isMultiplayerWorld()) {
            this.parseResults = null;
            this.mc.getSendQueue().addToSendQueue(new PacketRequestCommandManager(this.mc.thePlayer.username, text, cursor));
        } else {
            if (stringReader.canRead() && stringReader.peek() == '/') {
                stringReader.skip();
            }
            CommandDispatcher<CommandSource> dispatcher = this.getManager().getDispatcher();
            if (this.parseResults == null) {
                this.parseResults = dispatcher.parse(stringReader, this.commandSource);
            }
            if (cursor >= 1 || text.isEmpty()) {
                this.pendingSuggestions = dispatcher.getCompletionSuggestions(this.parseResults, cursor);
                this.pendingSuggestions.thenRun(() -> {
                    if (this.pendingSuggestions.isDone()) {
                        this.finishUpdatingSuggestions();
                    }
                });
            }
        }
    }

    private boolean shouldApplySuggestion(char c, int key) {
        return this.textField.isCharacterAllowed(c) || (key == 46 || key == 47) && (Keyboard.isKeyDown(29) || Keyboard.isKeyDown(157)) || key == 199 || key == 207 || key == 203 || key == 205 || key == 14 || key == 211;
    }

    private void finishUpdatingSuggestions() {
        this.suggestions = new ArrayList<Suggestion>();
        if (this.hidden) {
            return;
        }
        if (!serverSuggestions.isEmpty()) {
            for (JsonElement jsonSuggestion : serverSuggestions.getAsJsonArray("m")) {
                Suggestion suggestion = jsonSuggestion.getAsJsonObject().has("j") ? new Suggestion(new StringRange(jsonSuggestion.getAsJsonObject().get("g").getAsJsonObject().get("h").getAsInt(), jsonSuggestion.getAsJsonObject().get("g").getAsJsonObject().get("i").getAsInt()), jsonSuggestion.getAsJsonObject().get("f").getAsString(), () -> jsonSuggestion.getAsJsonObject().get("j").getAsString()) : new Suggestion(new StringRange(jsonSuggestion.getAsJsonObject().get("g").getAsJsonObject().get("h").getAsInt(), jsonSuggestion.getAsJsonObject().get("g").getAsJsonObject().get("i").getAsInt()), jsonSuggestion.getAsJsonObject().get("f").getAsString());
                if (this.tablessCursor > this.tablessMessage.length() || !suggestion.getText().startsWith(this.tablessMessage.substring(Math.min(suggestion.getRange().getStart(), this.tablessMessage.length()), Math.min(this.tablessCursor, Math.min(suggestion.getRange().getStart(), this.tablessMessage.length()))))) continue;
                this.suggestions.add(suggestion);
            }
        } else if (this.pendingSuggestions != null && this.pendingSuggestions.isDone()) {
            Suggestions suggestions = this.pendingSuggestions.join();
            this.suggestions.addAll(suggestions.getList());
        }
    }

    public void updateScreen(int dWheel) {
        this.finishUpdatingSuggestions();
        int cursorX = GuiElementChatSuggestions.getScaledMouseX(this.mc);
        int cursorY = GuiElementChatSuggestions.getScaledMouseY(this.mc);
        if (this.isHoveringOverSuggestions(cursorX, cursorY) && dWheel != 0) {
            this.scroll(Math.round(Math.signum(dWheel)) * -3);
        }
    }

    public void mouseClicked(int x, int y, int button) {
        if (this.isHoveringOverSuggestions(x, y) && button == 0) {
            this.cycleToSuggestion(this.getIndexOfSuggestionBeingHoveredOver(x, y).get());
        }
    }

    public boolean isHoveringOverSuggestions(int cursorX, int cursorY) {
        return this.getIndexOfSuggestionBeingHoveredOver(cursorX, cursorY).isPresent();
    }

    public Optional<Integer> getIndexOfSuggestionBeingHoveredOver(int cursorX, int cursorY) {
        if (this.suggestions.isEmpty() || this.hidden) {
            return Optional.empty();
        }
        int minX = this.xSupplier.get(this.textField, this, this.mc, true);
        int largestSuggestion = 0;
        for (Suggestion suggestion : this.suggestions) {
            if (this.fontRenderer.getStringWidth(suggestion.getText()) <= largestSuggestion) continue;
            largestSuggestion = this.fontRenderer.getStringWidth(suggestion.getText());
        }
        int minY = this.ySupplier.get(this.textField, this, this.mc, true);
        int suggestionBoxHeight = Math.min(this.suggestions.size(), 10) * 12;
        minY += (int)CommandHelper.linearInterpolation(this.anchor.yPosition, 1.0f, -suggestionBoxHeight - 1);
        int maxX = largestSuggestion + (minX -= (int)(this.anchor.xPosition * (float)(largestSuggestion + 2))) + 1;
        for (int i = 0; i < Math.min(this.suggestions.size(), 10); ++i) {
            int suggestionHeight = 12 * (-i + Math.min(this.suggestions.size(), 10) - 2) + 25;
            int suggestionMinY = minY + suggestionBoxHeight - suggestionHeight + 2;
            int suggestionMaxY = suggestionMinY + 12;
            if (cursorX < minX || cursorX >= maxX || cursorY < suggestionMinY || cursorY >= suggestionMaxY) continue;
            return Optional.of(i + this.scroll);
        }
        return Optional.empty();
    }

    private void resetAllManagerVariables() {
        this.commandIndex = -1;
        this.tablessMessage = this.textField.getText();
        this.tablessCursor = this.editor.getCursor();
        this.scroll = 0;
    }

    public void scroll(int amount) {
        this.scroll = MathHelper.clamp(this.scroll + amount, 0, Math.max(this.suggestions.size() - 10, 0));
    }

    public void cycleThroughSuggestions() {
        this.cycleThroughSuggestions(1);
    }

    public void cycleThroughSuggestions(int amount) {
        this.cycleToSuggestion(this.commandIndex + amount);
    }

    public void cycleToSuggestion(int index) {
        if (this.suggestions.isEmpty()) {
            return;
        }
        if (index < 0) {
            index += this.suggestions.size();
        }
        this.commandIndex = index % this.suggestions.size();
        Suggestion suggestion = this.suggestions.get(this.commandIndex);
        this.editor.setText(suggestion.apply(this.tablessMessage));
        this.editor.setCursor(suggestion.getRange().getStart() + suggestion.getText().length());
        if (this.commandIndex >= this.scroll + 10) {
            this.scroll = this.commandIndex - 10 + 1;
        } else if (this.commandIndex < this.scroll) {
            this.scroll = this.commandIndex;
        }
    }

    public List<Suggestion> getSuggestions() {
        return new ArrayList<Suggestion>(this.suggestions);
    }

    public int getScroll() {
        return this.scroll;
    }

    public int getCommandIndex() {
        return this.commandIndex;
    }

    public String getMessage() {
        return this.tablessMessage;
    }

    public int getCursor() {
        return this.tablessCursor;
    }

    @Nullable
    public ParseResults<CommandSource> getParseResults() {
        return this.parseResults;
    }

    public CommandSource getCommandSource() {
        return this.commandSource;
    }

    public int getSuggestionRangeStart() {
        if (!this.suggestions.isEmpty()) {
            return this.suggestions.get(0).getRange().getStart();
        }
        if (serverSuggestions.has("p")) {
            return serverSuggestions.get("p").getAsInt();
        }
        try {
            return this.parseResults != null ? this.parseResults.getContext().findSuggestionContext((int)this.tablessCursor).startPos : 0;
        }
        catch (IllegalStateException e) {
            LOGGER.error("", e);
            return 0;
        }
    }

    public void setAnchor(ComponentAnchor anchor) {
        this.anchor = anchor;
    }

    public String colorCodeText(String text, boolean requireSlash) {
        int readerCursor;
        StringReader stringReader;
        boolean isCommand;
        if (this.parseResults != null && !this.parseResults.getReader().getString().equals(text)) {
            this.parseResults = null;
        }
        boolean bl = isCommand = (stringReader = new StringReader(text)).canRead() && stringReader.peek() == '/' || !requireSlash;
        if (!isCommand || text.isEmpty()) {
            return text;
        }
        if (!serverSuggestions.isEmpty() && serverSuggestions.get("k") != null && serverSuggestions.get("k").getAsJsonObject().get("l") != null) {
            StringBuilder stringToDrawBuilder = new StringBuilder();
            int currentArgumentEnd = 0;
            int currentColor = 0;
            for (JsonElement jsonElement : serverSuggestions.getAsJsonObject("k").getAsJsonArray("l")) {
                int rangeStart = jsonElement.getAsJsonObject().getAsJsonObject("g").get("h").getAsInt();
                int rangeEnd = jsonElement.getAsJsonObject().getAsJsonObject("g").get("i").getAsInt();
                stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text, Math.min(currentArgumentEnd, text.length()), Math.min(rangeStart, text.length()));
                stringToDrawBuilder.append(ARGUMENT_STYLES.get(currentColor)).append(text, Math.min(rangeStart, text.length()), Math.min(rangeEnd, text.length()));
                currentArgumentEnd = rangeEnd;
                if (++currentColor < ARGUMENT_STYLES.size()) continue;
                currentColor = 0;
            }
            if (serverSuggestions.getAsJsonObject("e").get("a").getAsBoolean() && currentArgumentEnd < text.length()) {
                int remainingTextLength = serverSuggestions.getAsJsonObject("e").get("c").getAsInt();
                stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text, currentArgumentEnd, Math.min(serverSuggestions.getAsJsonObject("e").get("b").getAsInt(), text.length()));
                stringToDrawBuilder.append(TextFormatting.RED).append(text, Math.min(serverSuggestions.getAsJsonObject("e").get("b").getAsInt(), text.length()), Math.min(remainingTextLength, text.length()));
                currentArgumentEnd = remainingTextLength;
            }
            stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text.substring(Math.min(currentArgumentEnd, text.length())));
            return stringToDrawBuilder.toString();
        }
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        CommandDispatcher<CommandSource> dispatcher = this.getManager().getDispatcher();
        if (this.parseResults == null) {
            this.parseResults = dispatcher.parse(stringReader, this.getCommandSource());
        }
        StringBuilder stringToDrawBuilder = new StringBuilder();
        CommandContextBuilder<CommandSource> builder = this.parseResults.getContext().getLastChild();
        int currentArgumentEnd = 0;
        int currentColor = -1;
        for (ParsedArgument<CommandSource, ?> parsedArgument : builder.getArguments().values()) {
            int rangeStart;
            if (++currentColor >= ARGUMENT_STYLES.size()) {
                currentColor = 0;
            }
            if ((rangeStart = Math.max(parsedArgument.getRange().getStart(), 0)) >= text.length()) break;
            int rangeEnd = Math.min(parsedArgument.getRange().getEnd(), text.length());
            if (rangeEnd <= 0) continue;
            stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text, currentArgumentEnd, rangeStart);
            stringToDrawBuilder.append(ARGUMENT_STYLES.get(currentColor)).append(text, rangeStart, rangeEnd);
            currentArgumentEnd = rangeEnd;
        }
        if (this.parseResults.getReader().canRead() && (readerCursor = Math.max(this.parseResults.getReader().getCursor(), 0)) < text.length()) {
            int remainingTextLength = Math.min(readerCursor + this.parseResults.getReader().getRemainingLength(), text.length());
            stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text, currentArgumentEnd, readerCursor);
            stringToDrawBuilder.append(TextFormatting.RED).append(text, readerCursor, remainingTextLength);
            currentArgumentEnd = remainingTextLength;
        }
        stringToDrawBuilder.append(TextFormatting.LIGHT_GRAY).append(text.substring(currentArgumentEnd));
        return stringToDrawBuilder.toString();
    }

    public String getSuggestionPreview() {
        int mouseX = GuiElementChatSuggestions.getScaledMouseX(this.mc);
        int mouseY = GuiElementChatSuggestions.getScaledMouseY(this.mc) - 1;
        if (this.shouldDrawSuggestionPreview()) {
            Suggestion suggestionToRender = null;
            if (this.isHoveringOverSuggestions(mouseX, mouseY)) {
                suggestionToRender = this.getSuggestions().get(this.getIndexOfSuggestionBeingHoveredOver(mouseX, mouseY).get());
            } else if (!this.getSuggestions().isEmpty()) {
                suggestionToRender = this.getSuggestions().get(0);
            }
            if (suggestionToRender != null && suggestionToRender.getText().startsWith(this.editor.getText().substring(Math.min(suggestionToRender.getRange().getStart(), this.editor.getText().length())))) {
                return TextFormatting.LIGHT_GRAY + suggestionToRender.getText();
            }
        }
        return "";
    }

    private boolean shouldDrawSuggestionPreview() {
        boolean basedOnParseResults = this.parseResults != null && (this.tablessCursor == this.parseResults.getReader().getString().trim().length() || this.tablessCursor == this.parseResults.getReader().getString().length());
        boolean basedOnServer = serverSuggestions.has("e") && (this.tablessCursor == serverSuggestions.getAsJsonObject("e").get("d").getAsString().trim().length() || this.tablessCursor == serverSuggestions.getAsJsonObject("e").get("d").getAsString().length());
        return basedOnParseResults || basedOnServer;
    }

    public int getDefaultParameterPosition() {
        return this.fontRenderer.getStringWidth(this.getMessage().substring(0, Math.min(this.getSuggestionRangeStart(), this.getMessage().length()))) + 2;
    }

    public static void drawDottedRect(Gui gui, int minX, int minY, int maxX, int maxY, int argb, int dotSize) {
        for (int i = 0; i < (maxX - minX) / dotSize; ++i) {
            for (int j = 0; j < (maxY - minY) / dotSize; ++j) {
                if ((i + j) % 2 != 0) continue;
                gui.drawRect(minX + i * dotSize, minY + j * dotSize, minX + i * dotSize + dotSize, minY + j * dotSize + dotSize, argb);
            }
        }
    }

    public static int getScaledMouseX(Minecraft mc) {
        return Mouse.getX() / mc.resolution.getScale();
    }

    public static int getScaledMouseY(Minecraft mc) {
        return mc.resolution.getScaledHeightScreenCoords() - Mouse.getY() / mc.resolution.getScale();
    }

    static {
        ARGUMENT_STYLES = new ArrayList<String>();
        ARGUMENT_STYLES.add(TextFormatting.LIGHT_BLUE.toString());
        ARGUMENT_STYLES.add(TextFormatting.YELLOW.toString());
        ARGUMENT_STYLES.add(TextFormatting.LIME.toString());
        ARGUMENT_STYLES.add(TextFormatting.PINK.toString());
        ARGUMENT_STYLES.add(TextFormatting.ORANGE.toString());
    }
}

