/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import com.b100.utils.interfaces.Condition;
import com.mojang.logging.LogUtils;
import net.minecraft.client.gui.container.ScreenContainerAbstract;
import net.minecraft.client.gui.container.ScreenCrafting;
import net.minecraft.client.gui.container.ScreenFurnace;
import net.minecraft.client.gui.container.ScreenInventory;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.core.player.inventory.slot.Slot;
import org.slf4j.Logger;

public class ControllerInventoryHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final ControllerInput controllerInput;
    private Slot lastSlot;

    public ControllerInventoryHandler(ControllerInput controllerInput) {
        this.controllerInput = controllerInput;
    }

    public void handleAbstractCrafting(ScreenContainerAbstract container, Condition<Slot> isInventorySlot, Condition<Slot> isCraftingSlot, Condition<Slot> isResultSlot, int craftingSlot, int resultSlot, int invSlot) {
        Slot slot = this.controllerInput.getSlotAtCursor(container);
        if (this.controllerInput.buttonA.pressedThisFrame()) {
            for (Slot slot2 : container.inventorySlots.slots) {
                LOGGER.debug("{}: {}", (Object)slot2.index, (Object)slot2.getItem());
            }
        }
        if (slot != null && isCraftingSlot.isTrue(slot) && slot.hasItem() && this.controllerInput.buttonA.isPressed() && this.controllerInput.buttonA.getHoldTime() > 10 && this.controllerInput.buttonA.getHoldTime() % 2 == 1) {
            this.click(container, 0);
        }
        if (this.controllerInput.buttonLeftTrigger.pressedThisFrame()) {
            if (slot != null) {
                if (isCraftingSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (slot.index > 9) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, craftingSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, invSlot);
            }
        }
        if (this.controllerInput.buttonRightTrigger.pressedThisFrame()) {
            if (slot != null) {
                if (isResultSlot.isTrue(slot)) {
                    if (this.lastSlot != null) {
                        this.controllerInput.snapToSlot(container, this.lastSlot);
                    } else {
                        this.controllerInput.snapToSlot(container, invSlot);
                    }
                } else {
                    if (isInventorySlot.isTrue(slot)) {
                        this.lastSlot = slot;
                    }
                    this.controllerInput.snapToSlot(container, resultSlot);
                }
            } else {
                this.controllerInput.snapToSlot(container, resultSlot);
            }
        }
    }

    public void handleCrafting(ScreenCrafting crafting) {
        this.handleAbstractCrafting(crafting, e -> e.index > 9, e -> e.index > 0 && e.index < 10, e -> e.index == 0, 5, 0, 24);
    }

    public void handleInventory(ScreenInventory inventory) {
        this.handleAbstractCrafting(inventory, e -> e.index >= 9 && e.index <= 44, e -> e.index >= 1 && e.index <= 4, e -> e.index == 0, 1, 0, 22);
    }

    public void handleFurnace(ScreenFurnace furnace) {
        this.handleAbstractCrafting(furnace, e -> e.index >= 3 && e.index <= 38, e -> e.index >= 0 && e.index <= 1, e -> e.index == 2, 0, 2, 16);
    }

    public void click(ScreenContainerAbstract screen, int button) {
        screen.mouseClicked((int)this.controllerInput.cursorX, (int)this.controllerInput.cursorY, button);
    }
}

