/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.world.WorldSource;

public final class LightingCache {
    private final Minecraft mc = Minecraft.getMinecraft();
    private static final int CACHE_RANGE = 1;
    private static final int CACHE_SIZE = 3;
    private final boolean[] brightnessCached = new boolean[27];
    private final float[] brightnessValue = new float[27];
    private final boolean[] opacityCached = new boolean[27];
    private final boolean[] opacityValue = new boolean[27];
    private final boolean[] lightmapCoordCached = new boolean[27];
    private final int[] lightmapCoordValue = new int[27];
    private int offsetX = Integer.MAX_VALUE;
    private int offsetY = Integer.MAX_VALUE;
    private int offsetZ = Integer.MAX_VALUE;
    private Block<?> block;
    private WorldSource access;

    public void setupCache(Block<?> block, WorldSource access, int x, int y, int z) {
        if (x != this.offsetX || y != this.offsetY || z != this.offsetZ || this.block != block || this.access != access) {
            this.block = block;
            this.access = access;
            Arrays.fill(this.brightnessCached, false);
            Arrays.fill(this.opacityCached, false);
            Arrays.fill(this.lightmapCoordCached, false);
            this.offsetX = x;
            this.offsetY = y;
            this.offsetZ = z;
        }
    }

    private float calcBrightness(int x, int y, int z) {
        float brightness = this.block.getBlockBrightness(this.access, x, y, z);
        if (LightmapHelper.isLightmapEnabled() || this.mc.fullbright) {
            int lightEmission = this.block.emission;
            if (lightEmission >= 15) {
                return 1.0f;
            }
            if (!this.mc.isAmbientOcclusionEnabled()) {
                return 1.0f;
            }
            Block<?> block = this.access.getBlock(x, y, z);
            if (block == null) {
                return 1.0f;
            }
            return 1.0f - block.getAmbientOcclusionStrength(this.access, x, y, z);
        }
        return brightness;
    }

    public float getBrightness(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.brightnessCached[index]) {
            int x1 = relX + this.offsetX;
            int y1 = relY + this.offsetY;
            int z1 = relZ + this.offsetZ;
            this.brightnessValue[index] = this.calcBrightness(x1, y1, z1);
            this.brightnessCached[index] = true;
        }
        return this.brightnessValue[index];
    }

    public boolean getOpacity(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.opacityCached[index]) {
            this.opacityValue[index] = Blocks.solid[this.access.getBlockId(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ)];
            this.opacityCached[index] = true;
        }
        return this.opacityValue[index];
    }

    public int getLightmapCoord(int relX, int relY, int relZ) {
        int index = (relX + 1) * 3 * 3 + (relY + 1) * 3 + (relZ + 1);
        if (!this.lightmapCoordCached[index]) {
            int lightEmission = this.block.emission;
            this.lightmapCoordValue[index] = this.access.getLightmapCoord(relX + this.offsetX, relY + this.offsetY, relZ + this.offsetZ, lightEmission);
            this.lightmapCoordCached[index] = true;
        }
        return this.lightmapCoordValue[index];
    }
}

