/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.entity;

import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.render.Font;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.entity.EntityRenderer;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.Global;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.slf4j.Logger;

public class MobRenderer<T extends Mob>
extends EntityRenderer<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_ARMOR_LAYERS = 4;
    protected ModelBase mainModel;
    protected ModelBase armorModel;
    protected ModelBase overlayModel;
    protected String overlayTexture;
    private final Minecraft mc;

    public MobRenderer(ModelBase model, float shadowSize) {
        this.mainModel = model;
        this.shadowSize = shadowSize;
        this.mc = Minecraft.getMinecraft();
    }

    public void setArmorModel(ModelBase armor) {
        this.armorModel = armor;
    }

    public void setOverlayModel(ModelBase modelbase, String texture) {
        this.overlayModel = modelbase;
        this.overlayTexture = texture;
    }

    @Override
    public void render(Tessellator tessellator, T entity, double x, double y, double z, float yaw, float partialTick) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2884);
        this.mainModel.swingProgress = this.getSwingProgress(entity, partialTick);
        if (this.armorModel != null) {
            this.armorModel.swingProgress = this.mainModel.swingProgress;
        }
        if (this.overlayModel != null) {
            this.overlayModel.swingProgress = this.mainModel.swingProgress;
        }
        this.mainModel.isRiding = ((Entity)entity).isPassenger();
        if (this.armorModel != null) {
            this.armorModel.isRiding = this.mainModel.isRiding;
        }
        if (this.overlayModel != null) {
            this.overlayModel.isRiding = this.mainModel.isRiding;
        }
        try {
            int argb;
            float bodyYaw = ((Mob)entity).yBodyRotO + (((Mob)entity).yBodyRot - ((Mob)entity).yBodyRotO) * partialTick;
            float headYaw = ((Mob)entity).yRotO + (((Mob)entity).yRot - ((Mob)entity).yRotO) * partialTick;
            float headPitch = ((Mob)entity).xRotO + (((Mob)entity).xRot - ((Mob)entity).xRotO) * partialTick;
            this.translateModel(entity, x, y, z);
            float limbSway = this.limbSway(entity, partialTick);
            this.setupRotations(entity, limbSway, bodyYaw, partialTick);
            float scale = 0.0625f;
            GL12.glEnable((int)32826);
            GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
            this.setupScale(entity, partialTick);
            GL11.glTranslatef((float)0.0f, (float)(-24.0f * scale - 0.0078125f), (float)0.0f);
            float walkSpeed = ((Mob)entity).walkAnimSpeedO + (((Mob)entity).walkAnimSpeed - ((Mob)entity).walkAnimSpeedO) * partialTick;
            float walkProgress = ((Mob)entity).walkAnimPos - ((Mob)entity).walkAnimSpeed * (1.0f - partialTick);
            if (walkSpeed > 1.0f) {
                walkSpeed = 1.0f;
            }
            this.loadEntityTexture(entity);
            GL11.glEnable((int)3008);
            this.mainModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
            if (this.overlayModel != null) {
                this.bindTexture(this.overlayTexture);
                this.overlayModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
            }
            for (int renderPass = 0; renderPass < 4; ++renderPass) {
                if (!this.prepareArmor(entity, renderPass, partialTick)) continue;
                this.armorModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
            }
            this.renderAdditional(entity, partialTick);
            float brightness = ((Entity)entity).getBrightness(partialTick);
            if (Global.accessor.isFullbrightEnabled() || LightmapHelper.isLightmapEnabled()) {
                brightness = 1.0f;
            }
            if (((argb = this.getOverlayColor(entity, brightness, partialTick)) >> 24 & 0xFF) > 0 || ((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
                GL11.glDisable((int)3553);
                GL11.glDisable((int)3008);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glDepthFunc((int)514);
                if (((Mob)entity).hurtTime > 0 || ((Mob)entity).deathTime > 0) {
                    GL11.glColor4f((float)brightness, (float)0.0f, (float)0.0f, (float)0.4f);
                    this.mainModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    if (this.overlayModel != null) {
                        this.overlayModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                    for (int k = 0; k < 4; ++k) {
                        if (!this.prepareArmor(entity, k, partialTick)) continue;
                        GL11.glColor4f((float)brightness, (float)0.0f, (float)0.0f, (float)0.4f);
                        this.armorModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                }
                if ((argb >> 24 & 0xFF) > 0) {
                    float r = (float)(argb >> 16 & 0xFF) / 255.0f;
                    float g = (float)(argb >> 8 & 0xFF) / 255.0f;
                    float b = (float)(argb & 0xFF) / 255.0f;
                    float a = (float)(argb >> 24 & 0xFF) / 255.0f;
                    GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                    this.mainModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    if (this.overlayModel != null) {
                        this.overlayModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                    for (int l = 0; l < 4; ++l) {
                        if (!this.prepareArmor(entity, l, partialTick)) continue;
                        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
                        this.armorModel.render((Mob)entity, walkProgress, walkSpeed, limbSway, headYaw - bodyYaw, headPitch, scale, partialTick);
                    }
                }
                GL11.glDepthFunc((int)515);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)3008);
                GL11.glEnable((int)3553);
            }
            GL11.glDisable((int)32826);
        }
        catch (Exception exception) {
            LOGGER.error("Render exception in class '{}'!", (Object)this.getClass().getSimpleName(), (Object)exception);
        }
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        this.renderSpecials(tessellator, entity, x, y, z);
    }

    protected void translateModel(T entity, double x, double y, double z) {
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
    }

    protected void setupRotations(T entity, float ticksExisted, float bodyYaw, float partialTick) {
        GL11.glRotatef((float)(180.0f - bodyYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        if (((Mob)entity).deathTime > 0) {
            float rotationProgress = ((float)((Mob)entity).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((rotationProgress = MathHelper.sqrt_float(rotationProgress)) > 1.0f) {
                rotationProgress = 1.0f;
            }
            GL11.glRotatef((float)(rotationProgress * this.getMaxDeathRotation(entity)), (float)0.0f, (float)0.0f, (float)1.0f);
        }
    }

    protected float getSwingProgress(T entity, float partialTick) {
        return ((Mob)entity).getSwingProgress(partialTick);
    }

    protected float limbSway(T entity, float partialTick) {
        return (float)((Mob)entity).tickCount + partialTick;
    }

    protected void renderAdditional(T entity, float partialTick) {
    }

    protected boolean prepareArmor(T entity, int layer, float partialTick) {
        return false;
    }

    protected float getMaxDeathRotation(T entity) {
        return 90.0f;
    }

    protected int getOverlayColor(T entity, float brightness, float partialTick) {
        return 0;
    }

    protected void setupScale(T entity, float partialTick) {
    }

    protected void renderSpecials(Tessellator tessellator, T entity, double x, double y, double z) {
        if (this.mc.canRenderEntityLabel()) {
            this.renderLivingLabel(tessellator, entity, Integer.toString(((Mob)entity).id), x, y, z, 64, false);
        } else if (!((Mob)entity).nickname.isEmpty()) {
            this.renderLivingLabel(tessellator, entity, ((Mob)entity).getDisplayName(), x, y, z, 64, true);
        }
    }

    protected void renderLivingLabel(Tessellator tessellator, T entity, String s, double x, double y, double z, int maxDistance, boolean depthTest) {
        float f = (float)this.renderDispatcher.camera.distanceTo((Entity)entity);
        if (f > (float)maxDistance) {
            return;
        }
        Font font = this.getFont();
        float f1 = 1.6f;
        float f2 = 0.026666671f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x + 0.0f), (float)((float)y + ((Mob)entity).getHeadHeight() + 0.8f), (float)((float)z));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-this.renderDispatcher.viewLerpYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.renderDispatcher.viewLerpPitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.026666671f, (float)-0.026666671f, (float)0.026666671f);
        GL11.glDisable((int)2896);
        GL11.glDepthMask((boolean)false);
        if (!depthTest) {
            GL11.glDisable((int)2929);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int byte0 = 0;
        GL11.glDisable((int)3553);
        tessellator.startDrawingQuads();
        int j = font.getStringWidth(s) / 2;
        tessellator.setColorRGBA_F(0.0f, 0.0f, 0.0f, 0.25f);
        tessellator.addVertex(-j - 1, -1 + byte0, 0.0);
        tessellator.addVertex(-j - 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, 8 + byte0, 0.0);
        tessellator.addVertex(j + 1, -1 + byte0, 0.0);
        tessellator.draw();
        GL11.glEnable((int)3553);
        font.drawString(s, -font.getStringWidth(s) / 2, byte0, 0x20FFFFFF);
        if (!depthTest) {
            GL11.glEnable((int)2929);
        }
        GL11.glDepthMask((boolean)true);
        font.drawString(s, -font.getStringWidth(s) / 2, byte0, 0xFFFFFF);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void loadEntityTexture(T entity) {
        if (!((Boolean)Minecraft.getMinecraft().gameSettings.mobVariants.value).booleanValue()) {
            this.bindTexture(((Mob)entity).getDefaultEntityTexture());
        } else {
            this.bindTexture(((Mob)entity).getEntityTexture());
        }
    }
}

