/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.Cube;
import net.minecraft.client.render.model.ModelBase;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.util.helper.MathHelper;
import org.jetbrains.annotations.Nullable;

public class ModelChicken
extends ModelBase {
    public Cube head;
    public Cube body;
    public Cube rightLeg;
    public Cube leftLeg;
    public Cube rightWing;
    public Cube leftWing;
    public Cube bill;
    public Cube chin;

    public ModelChicken() {
        int yOff = 16;
        this.head = new Cube(0, 0);
        this.head.addBox(-2.0f, -6.0f, -2.0f, 4, 6, 3, 0.0f);
        this.head.setRotationPoint(0.0f, -1 + yOff, -4.0f);
        this.bill = new Cube(14, 0);
        this.bill.addBox(-2.0f, -4.0f, -4.0f, 4, 2, 2, 0.0f);
        this.bill.setRotationPoint(0.0f, -1 + yOff, -4.0f);
        this.chin = new Cube(14, 4);
        this.chin.addBox(-1.0f, -2.0f, -3.0f, 2, 2, 2, 0.0f);
        this.chin.setRotationPoint(0.0f, -1 + yOff, -4.0f);
        this.body = new Cube(0, 9);
        this.body.addBox(-3.0f, -4.0f, -3.0f, 6, 8, 6, 0.0f);
        this.body.setRotationPoint(0.0f, 0 + yOff, 0.0f);
        this.rightLeg = new Cube(26, 0);
        this.rightLeg.addBox(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.rightLeg.setRotationPoint(-2.0f, 3 + yOff, 1.0f);
        this.leftLeg = new Cube(26, 0);
        this.leftLeg.addBox(-1.0f, 0.0f, -3.0f, 3, 5, 3);
        this.leftLeg.setRotationPoint(1.0f, 3 + yOff, 1.0f);
        this.rightWing = new Cube(24, 13);
        this.rightWing.addBox(0.0f, 0.0f, -3.0f, 1, 4, 6);
        this.rightWing.setRotationPoint(-4.0f, -3 + yOff, 0.0f);
        this.leftWing = new Cube(24, 13);
        this.leftWing.addBox(-1.0f, 0.0f, -3.0f, 1, 4, 6);
        this.leftWing.setRotationPoint(4.0f, -3 + yOff, 0.0f);
    }

    @Override
    public void render(@Nullable Mob mob, float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale, float partialTick) {
        this.setupAnimation(mob, limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale, partialTick);
        this.head.render(scale);
        this.bill.render(scale);
        this.chin.render(scale);
        this.body.render(scale);
        this.rightLeg.render(scale);
        this.leftLeg.render(scale);
        this.rightWing.render(scale);
        this.leftWing.render(scale);
    }

    @Override
    public void setupAnimation(@Nullable Mob mob, float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale, float partialTick) {
        this.head.xRot = headPitch / 57.29578f;
        this.head.yRot = headYaw / 57.29578f;
        this.bill.xRot = this.head.xRot;
        this.bill.yRot = this.head.yRot;
        this.chin.xRot = this.head.xRot;
        this.chin.yRot = this.head.yRot;
        this.body.xRot = 1.5707964f;
        this.rightLeg.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.leftLeg.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        this.rightWing.zRot = limbPitch;
        this.leftWing.zRot = -limbPitch;
    }
}

