/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import com.b100.utils.ImageUtils;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class ScreenShot {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss");
    private static ByteBuffer buffer;
    private static byte[] pixelData;
    private static int[] imageData;

    public static String saveScreenshot(File mcDir, int width, int height) {
        try {
            File destFile;
            File screenshotsDir = new File(mcDir, "screenshots");
            screenshotsDir.mkdir();
            if (buffer == null || buffer.capacity() < width * height * 3) {
                buffer = BufferUtils.createByteBuffer((int)(width * height * 3));
            }
            if (imageData == null || imageData.length < width * height * 3) {
                pixelData = new byte[width * height * 3];
                imageData = new int[width * height];
            }
            GL11.glPixelStorei((int)3333, (int)1);
            GL11.glPixelStorei((int)3317, (int)1);
            buffer.clear();
            GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6407, (int)5121, (ByteBuffer)buffer);
            buffer.clear();
            String dateString = dateFormat.format(new Date());
            int k = 1;
            while ((destFile = new File(screenshotsDir, dateString + (k != 1 ? "_" + k : "") + ".png")).exists()) {
                ++k;
            }
            buffer.get(pixelData);
            for (int l = 0; l < width; ++l) {
                for (int i1 = 0; i1 < height; ++i1) {
                    int j2;
                    int j1 = l + (height - i1 - 1) * width;
                    int k1 = pixelData[j1 * 3 + 0] & 0xFF;
                    int l1 = pixelData[j1 * 3 + 1] & 0xFF;
                    int i2 = pixelData[j1 * 3 + 2] & 0xFF;
                    ScreenShot.imageData[l + i1 * width] = j2 = 0xFF000000 | k1 << 16 | l1 << 8 | i2;
                }
            }
            BufferedImage bufferedimage = new BufferedImage(width, height, 1);
            bufferedimage.setRGB(0, 0, width, height, imageData, 0, width);
            ImageIO.write((RenderedImage)bufferedimage, "png", destFile);
            try {
                ImageUtils.copyImageToClipboard(bufferedimage);
            }
            catch (Exception e) {
                LOGGER.error("Exception copying image to clipboard!", e);
            }
            return "Saved screenshot as " + destFile.getName();
        }
        catch (Exception exception) {
            LOGGER.error("Failed to save screenshot!", exception);
            return "Failed to save: " + exception;
        }
    }
}

