/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.monster;

import com.mojang.nbt.tags.ByteTag;
import com.mojang.nbt.tags.CompoundTag;
import com.mojang.nbt.tags.ListTag;
import com.mojang.nbt.tags.Tag;
import net.minecraft.core.entity.IArmorWearing;
import net.minecraft.core.entity.IItemHolding;
import net.minecraft.core.entity.monster.MobMonster;
import net.minecraft.core.enums.IArmorShape;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MobMonsterArmored<T extends IArmorShape>
extends MobMonster
implements IArmorWearing<T>,
IItemHolding {
    protected static final int DATA_ITEM_HELD = 24;
    protected static final int DATA_ARMOR_START = 25;
    protected static final int FLAG_LEFT_HANDED = 4;

    public MobMonsterArmored(@Nullable World world) {
        super(world);
    }

    @Override
    public void spawnInit() {
        super.spawnInit();
        this.setSharedFlag(4, this.random.nextInt(10) == 0);
    }

    @Override
    @Nullable
    public ItemStack getItemInArmorSlot(@NotNull T slot) {
        return this.entityData.getItemStack(25 + slot.getSlotIndex());
    }

    @Override
    public void setItemInArmorSlot(@NotNull T slot, @Nullable ItemStack item) {
        this.entityData.set(25 + slot.getSlotIndex(), item);
    }

    @Override
    @Nullable
    public ItemStack getHeldItem() {
        return this.entityData.getItemStack(24);
    }

    @Override
    public void setHeldItem(@Nullable ItemStack item) {
        this.entityData.set(24, item);
    }

    @Override
    public boolean isLeftHanded() {
        return this.getSharedFlag(4);
    }

    @Override
    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(24, null, ItemStack.class);
        for (int i = 0; i < this.getNumArmorSlots(); ++i) {
            this.entityData.define(25 + i, null, ItemStack.class);
        }
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        @NotNull ListTag list = new ListTag();
        for (int i = 0; i < this.getNumArmorSlots(); ++i) {
            ItemStack itemInSlot;
            @Nullable T slot = this.getArmorSlotByIndex(i);
            if (slot == null || (itemInSlot = this.getItemInArmorSlot(slot)) == null) continue;
            @NotNull CompoundTag armorTag = new CompoundTag();
            armorTag.putByte("Slot", (byte)i);
            itemInSlot.writeToNBT(armorTag);
            list.addTag(armorTag);
        }
        tag.putList("Armor", list);
        tag.putBoolean("LeftHanded", this.getSharedFlag(4));
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        @Nullable ListTag list = tag.getList("Armor");
        if (list != null) {
            for (Tag<?> t : list) {
                ItemStack stack;
                Object armorSlot;
                CompoundTag ct;
                Tag<?> t2;
                if (!(t instanceof CompoundTag) || !((t2 = (ct = (CompoundTag)t).getTag("Slot")) instanceof ByteTag) || (armorSlot = this.getArmorSlotByIndex(((Byte)((ByteTag)t2).getValue()).byteValue())) == null || (stack = ItemStack.readItemStackFromNbt(ct)) == null) continue;
                this.setItemInArmorSlot(armorSlot, stack);
            }
        }
        this.setSharedFlag(4, tag.getBoolean("LeftHanded"));
    }

    @Override
    protected void damageEntity(int damage, DamageType damageType) {
        float protection = 1.0f;
        if (damageType != null) {
            protection -= this.getTotalProtectionAmount(damageType);
        }
        protection = Math.max(protection, 0.01f);
        double d = (float)damage * protection;
        int newDamage = (int)((double)this.random.nextFloat() > 0.5 ? Math.floor(d) : Math.ceil(d));
        int preventedDamage = damage - newDamage;
        if (damageType != null && damageType.shouldDamageArmor()) {
            int armorDamage = (int)Math.ceil((double)preventedDamage / 4.0);
            this.damageArmor(armorDamage);
        }
        super.damageEntity(damage, damageType);
    }

    @Override
    public void lavaHurt() {
        if (!this.fireImmune) {
            float protection = 1.0f - this.getTotalProtectionAmount(DamageType.FIRE);
            protection = Math.max(protection, 0.01f);
            this.hurt(null, 4, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = (int)(80.0f + 520.0f * protection);
        }
    }

    @Override
    public void fireHurt() {
        if (!this.fireImmune) {
            float protection = 1.0f - this.getTotalProtectionAmount(DamageType.FIRE);
            protection = Math.max(protection, 0.01f);
            this.hurt(null, 1, DamageType.FIRE);
            this.maxFireTicks = this.remainingFireTicks = (int)(40.0f + 260.0f * protection);
        }
    }
}

