/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.item;

import net.minecraft.core.block.Block;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumBlockSoundEffectType;
import net.minecraft.core.item.ItemDoor;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDoorPainted
extends ItemDoor {
    public ItemDoorPainted(String name, String namespaceId, int id, Block<?> doorBottom, Block<?> doorTopId) {
        super(name, namespaceId, id, doorBottom, doorTopId);
    }

    @Override
    public boolean onUseItemOnBlock(@NotNull ItemStack itemstack, @Nullable Player player, @NotNull World world, int blockX, int blockY, int blockZ, @NotNull Side side, double xPlaced, double yPlaced) {
        int zOffset;
        if (!world.canPlaceInsideBlock(blockX, blockY, blockZ)) {
            blockX += side.getOffsetX();
            blockY += side.getOffsetY();
            blockZ += side.getOffsetZ();
        }
        if (!this.doorBlockBottom.canPlaceBlockAt(world, blockX, blockY, blockZ)) {
            return false;
        }
        Direction dir2 = player.getHorizontalPlacementDirection(side).rotate(3);
        int meta = dir2.getHorizontalIndex();
        int xOffset = -dir2.getOffsetX();
        int isSolidBlockLeft = (world.isBlockNormalCube(blockX - xOffset, blockY, blockZ - (zOffset = -dir2.getOffsetZ())) ? 1 : 0) + (world.isBlockNormalCube(blockX - xOffset, blockY + 1, blockZ - zOffset) ? 1 : 0);
        int isSolidBlockRight = (world.isBlockNormalCube(blockX + xOffset, blockY, blockZ + zOffset) ? 1 : 0) + (world.isBlockNormalCube(blockX + xOffset, blockY + 1, blockZ + zOffset) ? 1 : 0);
        boolean isDoorLeft = world.getBlockId(blockX - xOffset, blockY, blockZ - zOffset) == this.doorBlockBottom.id() || world.getBlockId(blockX - xOffset, blockY + 1, blockZ - zOffset) == this.doorBlockTop.id();
        boolean isDoorRight = world.getBlockId(blockX + xOffset, blockY, blockZ + zOffset) == this.doorBlockBottom.id() || world.getBlockId(blockX + xOffset, blockY + 1, blockZ + zOffset) == this.doorBlockTop.id();
        boolean isMirrored = false;
        if (isDoorLeft && !isDoorRight) {
            isMirrored = true;
        } else if (isSolidBlockRight > isSolidBlockLeft) {
            isMirrored = true;
        }
        if (isMirrored) {
            meta = meta - 1 & 3;
            meta += 4;
            meta |= 8;
        }
        world.noNeighborUpdate = true;
        world.setBlockAndMetadataWithNotify(blockX, blockY, blockZ, this.doorBlockBottom.id(), meta |= 15 - itemstack.getMetadata() << 4 & 0xF0);
        world.setBlockAndMetadataWithNotify(blockX, blockY + 1, blockZ, this.doorBlockTop.id(), meta);
        world.noNeighborUpdate = false;
        world.notifyBlocksOfNeighborChange(blockX, blockY, blockZ, this.doorBlockBottom.id());
        world.notifyBlocksOfNeighborChange(blockX, blockY + 1, blockZ, this.doorBlockTop.id());
        world.playBlockSoundEffect(player, (float)blockX + 0.5f, (float)blockY + 0.5f, (float)blockZ + 0.5f, this.doorBlockBottom, EnumBlockSoundEffectType.PLACE);
        itemstack.consumeItem(player);
        return true;
    }

    @Override
    public String getLanguageKey(ItemStack itemstack) {
        return super.getKey() + "." + DyeColor.colorFromItemMeta((int)itemstack.getMetadata()).colorID;
    }
}

